/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.context;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.history.ActionType;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class GovernActionContext {
    private static final ThreadLocal<ContextContainer> currentContext = new ThreadLocal();

    public static ContextContainer attachNewContext(ActionType actionType, @Nullable AuthCtx authCtx) {
        ContextContainer context = new ContextContainer(actionType, authCtx);
        return GovernActionContext.attachContext(context);
    }

    public static ContextContainer attachContext(ContextContainer context) {
        if (currentContext.get() != null) {
            throw new IllegalStateException("Context already exists");
        }
        currentContext.set(context);
        return context;
    }

    public static ContextContainer attachReuseCurrentContextOrCreateIfNone(ActionType actionType, @Nullable AuthCtx authCtx) {
        ContextContainer context = currentContext.get();
        if (context != null) {
            ++context.nestedLevel;
            return context;
        }
        return GovernActionContext.attachNewContext(actionType, authCtx);
    }

    public static boolean hasContext() {
        ContextContainer context = currentContext.get();
        return context != null;
    }

    public static ContextContainer getContext() {
        ContextContainer context = currentContext.get();
        if (context == null) {
            throw new IllegalStateException("Context has not been created");
        }
        return context;
    }

    public static ContextContainer removeContext() {
        ContextContainer context = currentContext.get();
        if (context == null) {
            throw new IllegalStateException("Context has not been created");
        }
        currentContext.remove();
        return context;
    }

    public static void cleanupContext() {
        ContextContainer context = currentContext.get();
        if (context != null && context.nestedLevel <= 0L) {
            currentContext.remove();
        }
    }

    @Nullable
    public static String getAuthCtxIdentifier() {
        return Optional.ofNullable(GovernActionContext.getContext().authCtx).map(authCtx -> authCtx.getAuthSource() == AuthCtx.AuthSource.NONE ? null : authCtx).map(AuthCtx::getIdentifier).orElse(null);
    }

    public static class ContextContainer
    implements AutoCloseable {
        public final ActionType actionType;
        @Nullable
        public final AuthCtx authCtx;
        public final OffsetDateTime actionStart;
        public Long actionId;
        public OffsetDateTime transactionStart;
        private long nestedLevel = 1L;

        private ContextContainer(ActionType actionType, @Nullable AuthCtx authCtx) {
            this.actionType = Objects.requireNonNull(actionType, "actionType cannot be null");
            this.authCtx = authCtx;
            this.actionStart = OffsetDateTime.now();
        }

        @Override
        public void close() {
            --this.nestedLevel;
            GovernActionContext.cleanupContext();
        }
    }
}

