/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.SourceType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.StoredReferenceFieldDefinition;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.governance.AutoGovernanceEffectiveAction;
import com.dataiku.gh.core.models.governance.GovernanceResult;
import com.dataiku.gh.core.models.governance.IGovernanceSettingsValidationService;
import com.dataiku.gh.core.models.governance.InputGovernanceSettings;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.migrator.IArtifactFixStrategy;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.governance.IGovernanceExecutorService;
import com.dataiku.gh.core.services.governance.config.IAutoGovernanceConfigurationDataService;
import com.dataiku.gh.core.services.governance.hide.IGovernanceHideService;
import com.dataiku.gh.core.services.governance.utils.GovernanceUtils;
import com.dataiku.gh.core.services.system.ISystemArtifactService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.IAutomaticConfigurationValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GovernanceExecutorService
implements IGovernanceExecutorService {
    protected static final DKULogger logger = DKULogger.getLogger((String)"gh.services.governance-service");
    @Autowired
    private ISystemArtifactService systemArtifactService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IArtifactFixStrategy artifactFixStrategy;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IGovernanceSettingsValidationService governanceSettingsValidationService;
    @Autowired
    private IAutomaticConfigurationValidationService automaticConfigurationValidationService;
    @Autowired
    private IAutoGovernanceConfigurationDataService autoGovernanceConfigurationDataService;
    @Autowired
    private IGovernanceHideService governanceHideService;

    @Override
    @GHMandatoryTransaction
    public GovernanceResult applyGovernanceSettingsToArtifact(String dataikuItemToGovernArtifactId, InputGovernanceSettings inputGovernanceSettings, boolean isAdvancedLicense) throws IOException {
        EnrichedArtifact governEnrichedArtifact;
        AutoGovernanceEffectiveAction action;
        EnrichedArtifact dataikuItemToGovernEnrichedArtifact = this.artifactsDataService.getArtifact(dataikuItemToGovernArtifactId);
        Artifact dataikuItemToGovernArtifact = dataikuItemToGovernEnrichedArtifact.artifact;
        this.governanceSettingsValidationService.validateInputSettings(dataikuItemToGovernEnrichedArtifact, inputGovernanceSettings);
        GovernanceArtifactDependencies artifactDependencies = this.getArtifactParentDependenciesForGovernance(dataikuItemToGovernEnrichedArtifact);
        if (artifactDependencies.parents.stream().anyMatch(parent -> GovernanceUtils.isHidden(parent.dataikuItem.artifact))) {
            logger.infoV("Hiding artifact of ID: %s because parents are hidden", new Object[]{dataikuItemToGovernArtifact.id});
            this.governanceHideService.systemSetArtifactVisibility(dataikuItemToGovernEnrichedArtifact, true);
            return GovernanceResult.buildHidden(dataikuItemToGovernArtifact.id, GovernanceResult.GovernanceResultStatusReason.PARENT_HIDDEN);
        }
        ArtifactAutoGovernanceConfiguration configToUpdate = GovernanceUtils.extractArtifactAutoGovernanceConfigurationToUpdate(inputGovernanceSettings);
        if (configToUpdate != null) {
            this.automaticConfigurationValidationService.validateArtifactAutoGovernanceConfiguration(configToUpdate, true);
            this.autoGovernanceConfigurationDataService.upsertDSSArtifactAutoGovernConfiguration(configToUpdate);
        }
        if ((action = GovernanceUtils.extractAction(inputGovernanceSettings)) == AutoGovernanceEffectiveAction.DO_NOTHING) {
            return GovernanceResult.buildNothing(dataikuItemToGovernArtifact.id, GovernanceResult.GovernanceResultStatusReason.AS_STATED);
        }
        if (action == AutoGovernanceEffectiveAction.HIDE) {
            if (artifactDependencies.current.governItem != null) {
                logger.infoV("Artifact of ID: %s is already governed", new Object[]{dataikuItemToGovernArtifact.id});
                return GovernanceResult.buildNothing(dataikuItemToGovernArtifact.id, GovernanceResult.GovernanceResultStatusReason.ALREADY_GOVERNED);
            }
            if (GovernanceUtils.isHidden(dataikuItemToGovernArtifact)) {
                logger.infoV("Artifact of ID: %s is already hidden", new Object[]{dataikuItemToGovernArtifact.id});
                return GovernanceResult.buildNothing(dataikuItemToGovernArtifact.id, GovernanceResult.GovernanceResultStatusReason.ALREADY_HIDDEN);
            }
            this.governanceHideService.systemSetArtifactVisibility(dataikuItemToGovernEnrichedArtifact, true);
            return GovernanceResult.buildHidden(dataikuItemToGovernArtifact.id, GovernanceResult.GovernanceResultStatusReason.AS_STATED);
        }
        if (action != AutoGovernanceEffectiveAction.GOVERN) {
            throw new ValidationException("Unexpected action " + String.valueOf((Object)action));
        }
        if (artifactDependencies.current.governItem != null) {
            logger.infoV("Artifact of ID: %s is already governed", new Object[]{dataikuItemToGovernArtifact.id});
            return GovernanceResult.buildNothing(dataikuItemToGovernArtifact.id, GovernanceResult.GovernanceResultStatusReason.ALREADY_GOVERNED);
        }
        if (artifactDependencies.parents.stream().anyMatch(parent -> !GovernanceUtils.isGoverned(parent.dataikuItem.artifact))) {
            logger.infoV("Artifact of ID: %s has an ungoverned parent", new Object[]{dataikuItemToGovernArtifact.id});
            return GovernanceResult.buildNothing(dataikuItemToGovernArtifact.id, GovernanceResult.GovernanceResultStatusReason.PARENT_NOT_GOVERNED);
        }
        if (!isAdvancedLicense && !GovernanceUtils.artifactIsGovernableWithAdvancedLicense(dataikuItemToGovernArtifact)) {
            logger.infoV("Skip governing artifact of ID: %s due to license restriction", new Object[]{dataikuItemToGovernArtifact.id});
            return GovernanceResult.buildNothing(dataikuItemToGovernArtifact.id, GovernanceResult.GovernanceResultStatusReason.LICENSE_RESTRICTION);
        }
        if (GovernanceUtils.isHidden(dataikuItemToGovernArtifact)) {
            this.governanceHideService.systemSetArtifactVisibility(dataikuItemToGovernEnrichedArtifact, false);
        } else {
            this.governanceHideService.systemSetChildrenVisibility(dataikuItemToGovernEnrichedArtifact, false);
        }
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(dataikuItemToGovernArtifact.blueprintVersionId) && inputGovernanceSettings instanceof InputGovernanceSettings.ExistingProjectSettings) {
            InputGovernanceSettings.ExistingProjectSettings existingProjectSettings = (InputGovernanceSettings.ExistingProjectSettings)inputGovernanceSettings;
            governEnrichedArtifact = this.artifactsDataService.getArtifact(existingProjectSettings.artifactId);
        } else {
            BlueprintVersionId governBlueprintVersionId = GovernanceUtils.extractGoverningBlueprintVersion(inputGovernanceSettings);
            if (governBlueprintVersionId == null) {
                throw new ValidationException("No blueprint version to use for creation when governing using an existing project for item with id `" + dataikuItemToGovernArtifact.id + "`");
            }
            Artifact prefilledArtifact = GovernanceUtils.extractPrefilledGovernArtifact(inputGovernanceSettings);
            Artifact artifact = prefilledArtifact != null ? prefilledArtifact : new Artifact();
            artifact.blueprintVersionId = governBlueprintVersionId;
            artifact.name = dataikuItemToGovernArtifact.name;
            if (SystemProvidedConstants.GOVERN_PROJECT.matchBlueprint(governBlueprintVersionId) && inputGovernanceSettings instanceof InputGovernanceSettings.ProjectSettings) {
                InputGovernanceSettings.ProjectSettings createProjectSettings = (InputGovernanceSettings.ProjectSettings)inputGovernanceSettings;
                String businessInitiativeArtifactId = createProjectSettings.businessInitiativeArtifactId;
                if (StringUtils.isNotBlank((CharSequence)businessInitiativeArtifactId)) {
                    EnrichedBlueprintVersion projectBPV = this.blueprintsDataService.getBlueprintVersion(createProjectSettings.blueprintVersionId);
                    FieldDefinition fieldDef = projectBPV.blueprintVersion.fieldDefinitions.get("business_initiative");
                    if (fieldDef == null || fieldDef.fieldType != FieldType.REFERENCE || fieldDef.sourceType != SourceType.STORE || !(fieldDef instanceof StoredReferenceFieldDefinition) || !((StoredReferenceFieldDefinition)fieldDef).allowedBlueprints.contains(SystemProvidedConstants.BUSINESS_INITIATIVE.blueprintId)) {
                        logger.warnV("Ignoring selected parent business initiative because selected blueprint version for Govern Project has an invalid field: %s, %s", new Object[]{projectBPV.blueprintVersion.id, "business_initiative"});
                    } else {
                        artifact.fields.put("business_initiative", fieldDef.listConfig != null ? Lists.newArrayList((Object[])new String[]{businessInitiativeArtifactId}) : businessInitiativeArtifactId);
                    }
                }
            } else {
                Optional.ofNullable(artifactDependencies.parents.get(0)).map(p -> p.governItem).map(ea -> ea.artifact.id).ifPresent(governParentId -> {
                    if (SystemProvidedConstants.GOVERN_DATASET.matchBlueprint(governBlueprintVersionId)) {
                        artifact.fields.put("govern_project", governParentId);
                    } else if (SystemProvidedConstants.GOVERN_BUNDLE.matchBlueprint(governBlueprintVersionId)) {
                        artifact.fields.put("govern_project", governParentId);
                    } else if (SystemProvidedConstants.GOVERN_MODEL.matchBlueprint(governBlueprintVersionId)) {
                        artifact.fields.put("govern_project", governParentId);
                    } else if (SystemProvidedConstants.GOVERN_MODEL_VERSION.matchBlueprint(governBlueprintVersionId)) {
                        artifact.fields.put("govern_model", governParentId);
                    }
                });
            }
            governEnrichedArtifact = this.systemArtifactService.createSystemArtifact(governBlueprintVersionId, artifact);
            if (this.artifactFixStrategy.fixArtifact(governEnrichedArtifact)) {
                governEnrichedArtifact = this.systemArtifactService.updateSystemArtifact(governEnrichedArtifact.artifact);
            }
        }
        logger.infoV("Governing artifact of ID: %s", new Object[]{dataikuItemToGovernArtifact.id});
        dataikuItemToGovernArtifact.fields.put("governed_by", governEnrichedArtifact.artifact.id);
        dataikuItemToGovernArtifact = this.systemArtifactService.updateSystemArtifact((Artifact)dataikuItemToGovernArtifact).artifact;
        String governArtifactId = governEnrichedArtifact.artifact.id;
        for (EnrichedArtifact governChildAlreadyExisting : artifactDependencies.children.stream().map(a -> a.governItem).filter(Objects::nonNull).toList()) {
            BlueprintVersionId childBPVID = governChildAlreadyExisting.artifact.blueprintVersionId;
            if (SystemProvidedConstants.GOVERN_BUNDLE.matchBlueprint(childBPVID)) {
                this.systemArtifactService.updateSystemArtifact(governChildAlreadyExisting.artifact.id, ea -> ea.artifact.fields.put("govern_project", governArtifactId));
                continue;
            }
            if (SystemProvidedConstants.GOVERN_MODEL.matchBlueprint(childBPVID)) {
                this.systemArtifactService.updateSystemArtifact(governChildAlreadyExisting.artifact.id, ea -> ea.artifact.fields.put("govern_project", governArtifactId));
                continue;
            }
            if (!SystemProvidedConstants.GOVERN_MODEL_VERSION.matchBlueprint(childBPVID)) continue;
            this.systemArtifactService.updateSystemArtifact(governChildAlreadyExisting.artifact.id, ea -> ea.artifact.fields.put("govern_model", governArtifactId));
        }
        return GovernanceResult.buildGoverned(dataikuItemToGovernArtifact.id, governEnrichedArtifact.artifact.id);
    }

    private GovernanceArtifactDependencies getArtifactParentDependenciesForGovernance(EnrichedArtifact dataikuItemToGovernArtifact) throws IOException {
        GovernanceArtifactDependencies artifactDependencies = new GovernanceArtifactDependencies();
        artifactDependencies.current = DataikuGovernPair.of(dataikuItemToGovernArtifact, this.getGovernArtifact(dataikuItemToGovernArtifact));
        EnrichedArtifact parent = dataikuItemToGovernArtifact;
        while ((parent = this.getParent(parent)) != null) {
            artifactDependencies.parents.add(DataikuGovernPair.of(parent, this.getGovernArtifact(parent)));
        }
        for (String referencedChildArtifactId : GovernanceUtils.getDataikuItemChildrenIds(dataikuItemToGovernArtifact.artifact)) {
            EnrichedArtifact dataikuItem = this.artifactsDataService.getArtifact(referencedChildArtifactId);
            artifactDependencies.children.add(DataikuGovernPair.of(dataikuItem, this.getGovernArtifact(dataikuItem)));
        }
        return artifactDependencies;
    }

    @Nullable
    private EnrichedArtifact getParent(EnrichedArtifact ea) throws IOException {
        String parentArtifactId = Optional.ofNullable(ea.blueprintVersion.hierarchicalParentFieldId).map(fieldId -> ea.artifact.fields.get(fieldId)).filter(String.class::isInstance).orElse(null);
        if (parentArtifactId == null) {
            return null;
        }
        return this.artifactsDataService.getArtifact(parentArtifactId);
    }

    private EnrichedArtifact getGovernArtifact(EnrichedArtifact dataikuItem) throws IOException {
        Optional<String> governId = Optional.ofNullable(dataikuItem.artifact.fields.get("governed_by")).filter(String.class::isInstance).map(id -> (String)id);
        if (governId.isPresent()) {
            return this.artifactsDataService.getArtifact(governId.get());
        }
        return null;
    }

    private static class GovernanceArtifactDependencies {
        public DataikuGovernPair current;
        public List<DataikuGovernPair> parents = new ArrayList<DataikuGovernPair>();
        public List<DataikuGovernPair> children = new ArrayList<DataikuGovernPair>();

        private GovernanceArtifactDependencies() {
        }
    }

    private static class DataikuGovernPair {
        public EnrichedArtifact dataikuItem;
        @Nullable
        public EnrichedArtifact governItem;

        private DataikuGovernPair() {
        }

        public static DataikuGovernPair of(EnrichedArtifact dataikuItem, @Nullable EnrichedArtifact governItem) {
            DataikuGovernPair p = new DataikuGovernPair();
            p.dataikuItem = dataikuItem;
            p.governItem = governItem;
            return p;
        }
    }
}

