/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.history;

import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffApproval;
import com.dataiku.gh.core.models.signoff.SignoffFeedback;
import com.dataiku.gh.core.models.signoff.SignoffId;
import com.dataiku.gh.core.models.signoff.SignoffRecurrenceConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroup;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.models.ui.UIDiff;
import com.dataiku.gh.core.services.history.IArtifactHistoryDiffService;
import com.google.common.base.Equivalence;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ArtifactHistoryDiffService
implements IArtifactHistoryDiffService {
    @Override
    public List<UIDiff> computeDiff(UIArtifact newUIArtifact, UIArtifact oldUIArtifact) {
        ArrayList<UIDiff> diff = new ArrayList<UIDiff>();
        Artifact newArtifact = newUIArtifact.artifact;
        Artifact oldArtifact = oldUIArtifact.artifact;
        if (!JSON.jsonEquals((Object)newUIArtifact.blueprintVersion, (Object)oldUIArtifact.blueprintVersion)) {
            if (!JSON.jsonEquals((Object)newUIArtifact.blueprintVersion.workflowDefinition, (Object)oldUIArtifact.blueprintVersion.workflowDefinition) && !JSON.jsonEquals(newUIArtifact.blueprintVersion.workflowDefinition.stepDefinitions, oldUIArtifact.blueprintVersion.workflowDefinition.stepDefinitions)) {
                diff.add(new UIDiff(UIDiff.DiffPath.BLUEPRINTVERSION_STEP_DEFINITIONS, oldUIArtifact.blueprintVersion.workflowDefinition.stepDefinitions, newUIArtifact.blueprintVersion.workflowDefinition.stepDefinitions));
            }
            if (!JSON.jsonEquals(newUIArtifact.blueprintVersion.fieldDefinitions, oldUIArtifact.blueprintVersion.fieldDefinitions)) {
                Map<String, FieldDefinition> oldFieldDefinitions = oldUIArtifact.blueprintVersion.fieldDefinitions;
                Map<String, FieldDefinition> newFieldDefinitions = newUIArtifact.blueprintVersion.fieldDefinitions;
                HashMap<String, UIDiff> fieldsDiff = new HashMap<String, UIDiff>();
                for (Map.Entry<String, FieldDefinition> entry : oldFieldDefinitions.entrySet()) {
                    if (!newFieldDefinitions.containsKey(entry.getKey())) {
                        fieldsDiff.put(entry.getKey(), new UIDiff(UIDiff.DiffPath.BLUEPRINTVERSION_FIELD_DEFINITIONS, (Object)entry.getValue(), null));
                        continue;
                    }
                    if (!JSON.jsonEquals((Object)((Object)entry.getValue().fieldType), (Object)((Object)((FieldDefinition)newFieldDefinitions.get((Object)entry.getKey())).fieldType))) {
                        fieldsDiff.put(entry.getKey(), new UIDiff(UIDiff.DiffPath.BLUEPRINTVERSION_FIELD_DEFINITIONS, (Object)entry.getValue(), newFieldDefinitions.get(entry.getKey())));
                        continue;
                    }
                    if (JSON.jsonEquals((Object)entry.getValue().label, (Object)((FieldDefinition)newFieldDefinitions.get((Object)entry.getKey())).label)) continue;
                    fieldsDiff.put(entry.getKey(), new UIDiff(UIDiff.DiffPath.BLUEPRINTVERSION_FIELD_DEFINITIONS, (Object)entry.getValue(), newFieldDefinitions.get(entry.getKey())));
                }
                for (Map.Entry<String, FieldDefinition> entry : newFieldDefinitions.entrySet()) {
                    if (fieldsDiff.containsKey(entry.getKey()) || oldFieldDefinitions.containsKey(entry.getKey())) continue;
                    fieldsDiff.put(entry.getKey(), new UIDiff(UIDiff.DiffPath.BLUEPRINTVERSION_FIELD_DEFINITIONS, null, (Object)entry.getValue()));
                }
                diff.addAll(fieldsDiff.values());
            }
        }
        if (!JSON.jsonEquals((Object)newArtifact.blueprintVersionId, (Object)oldArtifact.blueprintVersionId)) {
            diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_BLUEPRINTVERSION_VERSION, (Object)oldArtifact.blueprintVersionId.versionId, (Object)newArtifact.blueprintVersionId.versionId));
        }
        if (!JSON.jsonEquals((Object)newArtifact.name, (Object)oldArtifact.name)) {
            diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_NAME, (Object)oldArtifact.name, (Object)newArtifact.name));
        }
        if (!JSON.jsonEquals((Object)newArtifact.status, (Object)oldArtifact.status) && !JSON.jsonEquals((Object)newArtifact.status.archived, (Object)oldArtifact.status.archived)) {
            diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_WORKFLOW_ARCHIVED, (Object)oldArtifact.status.archived, (Object)newArtifact.status.archived));
        }
        if (!JSON.jsonEquals((Object)newArtifact.workflow, (Object)oldArtifact.workflow)) {
            MapDifference difference = Maps.difference(oldArtifact.workflow.steps, newArtifact.workflow.steps, (Equivalence)new Equivalence<ArtifactWorkflowStep>(){

                protected boolean doEquivalent(ArtifactWorkflowStep a, ArtifactWorkflowStep b) {
                    return Objects.equals((Object)a.status, (Object)b.status);
                }

                protected int doHash(ArtifactWorkflowStep artifactWorkflowStep) {
                    return Objects.hashCode((Object)artifactWorkflowStep.status);
                }
            });
            for (String stepDefinitionId : this.smartMergeStepDefinitionIds(oldUIArtifact, newUIArtifact)) {
                if (difference.entriesOnlyOnLeft().containsKey(stepDefinitionId)) {
                    diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_WORKFLOW_PREFIX.withSuffix(stepDefinitionId), difference.entriesOnlyOnLeft().get(stepDefinitionId), null));
                }
                if (difference.entriesOnlyOnRight().containsKey(stepDefinitionId)) {
                    diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_WORKFLOW_PREFIX.withSuffix(stepDefinitionId), null, difference.entriesOnlyOnRight().get(stepDefinitionId)));
                }
                if (!difference.entriesDiffering().containsKey(stepDefinitionId)) continue;
                MapDifference.ValueDifference diffEntry = (MapDifference.ValueDifference)difference.entriesDiffering().get(stepDefinitionId);
                diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_WORKFLOW_PREFIX.withSuffix(stepDefinitionId), diffEntry.leftValue(), diffEntry.rightValue()));
            }
        }
        if (!JSON.jsonEquals(newArtifact.fields, oldArtifact.fields)) {
            for (String fieldId : Sets.union(newArtifact.fields.keySet(), oldArtifact.fields.keySet())) {
                if (JSON.jsonEquals((Object)newArtifact.fields.get(fieldId), (Object)oldArtifact.fields.get(fieldId))) continue;
                diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_FIELD_PREFIX.withSuffix(fieldId), oldArtifact.fields.get(fieldId), newArtifact.fields.get(fieldId)));
            }
        }
        if (!JSON.jsonEquals((Object)newArtifact.attachments, (Object)oldArtifact.attachments)) {
            if (!JSON.jsonEquals(newArtifact.attachments.references, oldArtifact.attachments.references)) {
                diff.add(new UIDiff(UIDiff.DiffPath.ATTACHMENT_REFERENCES, oldArtifact.attachments.references, newArtifact.attachments.references));
            }
            if (!JSON.jsonEquals(newArtifact.attachments.files, oldArtifact.attachments.files)) {
                diff.add(new UIDiff(UIDiff.DiffPath.ATTACHMENT_FILES, oldArtifact.attachments.files, newArtifact.attachments.files));
            }
        }
        if (!JSON.jsonEquals(newUIArtifact.signoffs, oldUIArtifact.signoffs)) {
            Map oldSignoffs = oldUIArtifact.signoffs.stream().collect(Collectors.toMap(Signoff::getSignoffId, Function.identity()));
            Map newSignoffs = newUIArtifact.signoffs.stream().collect(Collectors.toMap(Signoff::getSignoffId, Function.identity()));
            for (SignoffId signoffId : oldSignoffs.keySet()) {
                Signoff oldSignoff;
                Signoff newSignoff = (Signoff)newSignoffs.get(signoffId);
                if (JSON.jsonEquals((Object)newSignoff, (Object)(oldSignoff = (Signoff)oldSignoffs.get(signoffId)))) continue;
                String pathPrefix = UIDiff.DiffPath.SIGNOFF_PREFIX.withSuffix((String)oldSignoff.signoffId.stepId).path;
                diff.addAll(ArtifactHistoryDiffService.computeSignoffDiff(newSignoff, oldSignoff, pathPrefix));
            }
        }
        return diff;
    }

    @Override
    public List<UIDiff> computeCreationDiff(UIArtifact newUIArtifact) {
        ArrayList<UIDiff> diff = new ArrayList<UIDiff>();
        Artifact newArtifact = newUIArtifact.artifact;
        diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_NAME, null, (Object)newArtifact.name));
        for (StepDefinition stepDefinition : newUIArtifact.blueprintVersion.workflowDefinition.stepDefinitions) {
            if (!newArtifact.workflow.steps.containsKey(stepDefinition.id)) continue;
            diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_WORKFLOW_PREFIX.withSuffix(stepDefinition.id), null, (Object)newArtifact.workflow.steps.get(stepDefinition.id)));
        }
        for (Map.Entry entry : newArtifact.fields.entrySet()) {
            diff.add(new UIDiff(UIDiff.DiffPath.ARTIFACT_FIELD_PREFIX.withSuffix((String)entry.getKey()), null, entry.getValue()));
        }
        return diff;
    }

    private static List<UIDiff> computeSignoffDiff(Signoff newSignoff, Signoff oldSignoff, String pathPrefix) {
        ArrayList<UIDiff> diff = new ArrayList<UIDiff>();
        diff.addAll(ArtifactHistoryDiffService.computeConfigurationApproversDiff(newSignoff, oldSignoff, pathPrefix));
        diff.addAll(ArtifactHistoryDiffService.computeApproverResponseDiff(newSignoff, oldSignoff, pathPrefix));
        diff.addAll(ArtifactHistoryDiffService.computeSignoffStatusDiffs(newSignoff, oldSignoff, pathPrefix));
        diff.addAll(ArtifactHistoryDiffService.computeFeedbackUsersGroupsDiffs(newSignoff, oldSignoff, pathPrefix));
        diff.addAll(ArtifactHistoryDiffService.computeFeedbackResponsesDiffs(newSignoff, oldSignoff, pathPrefix));
        diff.addAll(ArtifactHistoryDiffService.computeRecurrenceConfigurationDiff(newSignoff, oldSignoff, pathPrefix));
        return diff;
    }

    private static List<UIDiff> computeRecurrenceConfigurationDiff(Signoff newSignoff, Signoff oldSignoff, String pathPrefix) {
        SignoffRecurrenceConfiguration newRecurrenceConfiguration;
        SignoffRecurrenceConfiguration oldRecurrenceConfiguration = oldSignoff != null ? oldSignoff.configuration.recurrenceConfiguration : null;
        SignoffRecurrenceConfiguration signoffRecurrenceConfiguration = newRecurrenceConfiguration = newSignoff != null ? newSignoff.configuration.recurrenceConfiguration : null;
        if (!JSON.jsonEquals((Object)newRecurrenceConfiguration, (Object)oldRecurrenceConfiguration)) {
            return Collections.singletonList(new UIDiff(UIDiff.DiffPath.SIGNOFF_RECURRENCE_CONFIGURATION_SUFFIX.withPrefix(pathPrefix), (Object)oldRecurrenceConfiguration, (Object)newRecurrenceConfiguration));
        }
        return Collections.emptyList();
    }

    private static List<UIDiff> computeConfigurationApproversDiff(Signoff newSignoff, Signoff oldSignoff, String pathPrefix) {
        List newApprovers;
        List oldApprovers = oldSignoff != null ? oldSignoff.configuration.approvers : Collections.emptyList();
        List<Object> list = newApprovers = newSignoff != null ? newSignoff.configuration.approvers : Collections.emptyList();
        if (!JSON.jsonEquals(newApprovers, oldApprovers)) {
            return Collections.singletonList(new UIDiff(UIDiff.DiffPath.SIGNOFF_CONFIGURATION_APPROVERS_SUFFIX.withPrefix(pathPrefix), oldApprovers, newApprovers));
        }
        return Collections.emptyList();
    }

    private static List<UIDiff> computeApproverResponseDiff(Signoff newSignoff, Signoff oldSignoff, String pathPrefix) {
        SignoffApproval newApproverResponse;
        SignoffApproval oldApproverResponse = oldSignoff != null ? oldSignoff.approverResponse : null;
        SignoffApproval signoffApproval = newApproverResponse = newSignoff != null ? newSignoff.approverResponse : null;
        if (!JSON.jsonEquals((Object)newApproverResponse, (Object)oldApproverResponse)) {
            return Collections.singletonList(new UIDiff(UIDiff.DiffPath.SIGNOFF_APPROVER_RESPONSE_SUFFIX.withPrefix(pathPrefix), (Object)oldApproverResponse, (Object)newApproverResponse));
        }
        return Collections.emptyList();
    }

    private static List<UIDiff> computeSignoffStatusDiffs(Signoff newSignoff, Signoff oldSignoff, String pathPrefix) {
        Signoff.SignoffStatus newStatus;
        Signoff.SignoffStatus oldStatus = oldSignoff != null ? oldSignoff.status : null;
        Signoff.SignoffStatus signoffStatus = newStatus = newSignoff != null ? newSignoff.status : null;
        if (!JSON.jsonEquals((Object)((Object)newStatus), (Object)((Object)oldStatus))) {
            return Collections.singletonList(new UIDiff(UIDiff.DiffPath.SIGNOFF_STATUS_SUFFIX.withPrefix(pathPrefix), (Object)oldStatus, (Object)newStatus));
        }
        return Collections.emptyList();
    }

    private static List<UIDiff> computeFeedbackResponsesDiffs(Signoff newSignoff, Signoff oldSignoff, String pathPrefix) {
        List<Object> newFeedbackResponses;
        ArrayList<UIDiff> diffs = new ArrayList<UIDiff>();
        List<Object> oldFeedbackResponses = oldSignoff != null ? oldSignoff.feedbackResponses : Collections.emptyList();
        List<Object> list = newFeedbackResponses = newSignoff != null ? newSignoff.feedbackResponses : Collections.emptyList();
        if (!JSON.jsonEquals(newFeedbackResponses, oldFeedbackResponses)) {
            Map newFeedbacks = newFeedbackResponses.stream().collect(Collectors.toMap(SignoffFeedback::getId, Function.identity()));
            Map oldFeedbacks = oldFeedbackResponses.stream().collect(Collectors.toMap(SignoffFeedback::getId, Function.identity()));
            HashSet<String> allIds = new HashSet<String>(newFeedbacks.keySet());
            allIds.addAll(oldFeedbacks.keySet());
            for (String feedbackId : allIds) {
                SignoffFeedback oldFeedback = (SignoffFeedback)oldFeedbacks.get(feedbackId);
                SignoffFeedback newFeedback = (SignoffFeedback)newFeedbacks.get(feedbackId);
                if (JSON.jsonEquals((Object)newFeedback, (Object)oldFeedback)) continue;
                diffs.add(new UIDiff(UIDiff.DiffPath.SIGNOFF_FEEDBACK_RESPONSE_SUFFIX.withPrefix(pathPrefix), (Object)oldFeedback, (Object)newFeedback));
            }
        }
        return diffs;
    }

    private static List<UIDiff> computeFeedbackUsersGroupsDiffs(Signoff newSignoff, Signoff oldSignoff, String pathPrefix) {
        List newFeedbackUsersGroups;
        ArrayList<UIDiff> diffs = new ArrayList<UIDiff>();
        List oldFeedbackUsersGroups = oldSignoff != null ? oldSignoff.configuration.feedbackUsersGroups : Collections.emptyList();
        List<Object> list = newFeedbackUsersGroups = newSignoff != null ? newSignoff.configuration.feedbackUsersGroups : Collections.emptyList();
        if (!JSON.jsonEquals(newFeedbackUsersGroups, oldFeedbackUsersGroups)) {
            Map newSignoffUsersGroups = newFeedbackUsersGroups.stream().collect(Collectors.toMap(SignoffUsersGroup::getId, Function.identity()));
            Map oldSignoffUsersGroups = oldFeedbackUsersGroups.stream().collect(Collectors.toMap(SignoffUsersGroup::getId, Function.identity()));
            HashSet<String> allIds = new HashSet<String>(newSignoffUsersGroups.keySet());
            allIds.addAll(oldSignoffUsersGroups.keySet());
            for (String signoffUsersGroupId : allIds) {
                if (newSignoffUsersGroups.containsKey(signoffUsersGroupId) && oldSignoffUsersGroups.containsKey(signoffUsersGroupId)) {
                    if (JSON.jsonEquals((Object)((SignoffUsersGroup)newSignoffUsersGroups.get(signoffUsersGroupId)), (Object)((SignoffUsersGroup)oldSignoffUsersGroups.get(signoffUsersGroupId)))) continue;
                    diffs.add(new UIDiff(UIDiff.DiffPath.SIGNOFF_CONFIGURATION_FEEDBACK_USERSGROUPS_SUFFIX.withPrefix(pathPrefix), oldSignoffUsersGroups.get(signoffUsersGroupId), newSignoffUsersGroups.get(signoffUsersGroupId)));
                    continue;
                }
                if (newSignoffUsersGroups.containsKey(signoffUsersGroupId)) {
                    diffs.add(new UIDiff(UIDiff.DiffPath.SIGNOFF_CONFIGURATION_FEEDBACK_USERSGROUPS_SUFFIX.withPrefix(pathPrefix), null, newSignoffUsersGroups.get(signoffUsersGroupId)));
                    continue;
                }
                diffs.add(new UIDiff(UIDiff.DiffPath.SIGNOFF_CONFIGURATION_FEEDBACK_USERSGROUPS_SUFFIX.withPrefix(pathPrefix), oldSignoffUsersGroups.get(signoffUsersGroupId), null));
            }
        }
        return diffs;
    }

    public List<String> smartMergeStepDefinitionIds(UIArtifact oldArtifact, UIArtifact newArtifact) {
        class OrderedStepId
        implements Comparable<OrderedStepId> {
            private final String id;
            private final int index;

            private OrderedStepId(String id, int index) {
                this.id = id;
                this.index = index;
            }

            @Override
            public int compareTo(OrderedStepId o) {
                return this.index - o.index;
            }

            public boolean equals(Object o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OrderedStepId that = (OrderedStepId)o;
                return Objects.equals(this.id, that.id);
            }

            public int hashCode() {
                return Objects.hashCode(this.id);
            }
        }
        OrderedStepId orderedStepDefinition2;
        int i;
        ArrayList<OrderedStepId> oldOrdered = new ArrayList<OrderedStepId>(oldArtifact.blueprintVersion.workflowDefinition.stepDefinitions.size());
        ArrayList<OrderedStepId> newOrdered = new ArrayList<OrderedStepId>(newArtifact.blueprintVersion.workflowDefinition.stepDefinitions.size());
        for (i = 0; i < oldArtifact.blueprintVersion.workflowDefinition.stepDefinitions.size(); ++i) {
            orderedStepDefinition2 = new OrderedStepId(oldArtifact.blueprintVersion.workflowDefinition.stepDefinitions.get((int)i).id, i);
            oldOrdered.add(orderedStepDefinition2);
        }
        for (i = 0; i < newArtifact.blueprintVersion.workflowDefinition.stepDefinitions.size(); ++i) {
            orderedStepDefinition2 = new OrderedStepId(newArtifact.blueprintVersion.workflowDefinition.stepDefinitions.get((int)i).id, i);
            newOrdered.add(orderedStepDefinition2);
        }
        return CollectionUtils.collate(oldOrdered, newOrdered, (boolean)false).stream().distinct().map(orderedStepDefinition -> orderedStepDefinition.id).collect(Collectors.toList());
    }
}

