/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.context;

import com.dataiku.dip.DKUApp;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserRolesCacheContext {
    private static final ThreadLocal<ContextContainer> currentContext = new ThreadLocal();
    private static final long WATCH_DOG = DKUApp.getParams().getLongParam("dku.govern.roles-cache.watch-dog", 1000000L);

    public static boolean hasContext() {
        return currentContext.get() != null;
    }

    public static ContextContainer attachNewContext() {
        if (UserRolesCacheContext.hasContext()) {
            throw new IllegalStateException("Context already exists");
        }
        ContextContainer context = new ContextContainer();
        currentContext.set(context);
        return context;
    }

    public static void clearContext() {
        currentContext.remove();
    }

    public static void addBlueprintLevelRoles(String blueprintId, Set<String> roles) {
        if (UserRolesCacheContext.hasContext() && (long)UserRolesCacheContext.currentContext.get().blueprintsRoles.size() < WATCH_DOG) {
            UserRolesCacheContext.currentContext.get().blueprintsRoles.put(blueprintId, new HashSet<String>(roles));
        }
    }

    public static Set<String> getBlueprintLevelRolesOrNull(String blueprintId) {
        if (UserRolesCacheContext.hasContext()) {
            return UserRolesCacheContext.currentContext.get().blueprintsRoles.get(blueprintId);
        }
        return null;
    }

    public static void addBlueprintVersionLevelRoles(BlueprintVersionId blueprintVersionId, Set<String> roles) {
        if (UserRolesCacheContext.hasContext() && (long)UserRolesCacheContext.currentContext.get().blueprintVersionsRoles.size() < WATCH_DOG) {
            UserRolesCacheContext.currentContext.get().blueprintVersionsRoles.put(blueprintVersionId, new HashSet<String>(roles));
        }
    }

    public static Set<String> getBlueprintVersionLevelRolesOrNull(BlueprintVersionId blueprintVersionId) {
        if (UserRolesCacheContext.hasContext()) {
            return UserRolesCacheContext.currentContext.get().blueprintVersionsRoles.get(blueprintVersionId);
        }
        return null;
    }

    public static void addArtifactExistingLevelRoles(String artifactId, Set<String> roles) {
        if (UserRolesCacheContext.hasContext() && (long)UserRolesCacheContext.currentContext.get().artifactsExistingRoles.size() < WATCH_DOG) {
            UserRolesCacheContext.currentContext.get().artifactsExistingRoles.put(artifactId, new HashSet<String>(roles));
        }
    }

    public static Set<String> getArtifactExistingLevelRolesOrNull(String artifactId) {
        if (UserRolesCacheContext.hasContext()) {
            return UserRolesCacheContext.currentContext.get().artifactsExistingRoles.get(artifactId);
        }
        return null;
    }

    public static void addArtifactDeletedLevelRoles(String artifactId, Set<String> roles) {
        if (UserRolesCacheContext.hasContext() && (long)UserRolesCacheContext.currentContext.get().artifactsDeletedRoles.size() < WATCH_DOG) {
            UserRolesCacheContext.currentContext.get().artifactsDeletedRoles.put(artifactId, new HashSet<String>(roles));
        }
    }

    public static Set<String> getArtifactDeletedLevelRolesOrNull(String artifactId) {
        if (UserRolesCacheContext.hasContext()) {
            return UserRolesCacheContext.currentContext.get().artifactsDeletedRoles.get(artifactId);
        }
        return null;
    }

    public static class ContextContainer
    implements AutoCloseable {
        public Map<String, Set<String>> blueprintsRoles = new HashMap<String, Set<String>>();
        public Map<BlueprintVersionId, Set<String>> blueprintVersionsRoles = new HashMap<BlueprintVersionId, Set<String>>();
        public Map<String, Set<String>> artifactsExistingRoles = new HashMap<String, Set<String>>();
        public Map<String, Set<String>> artifactsDeletedRoles = new HashMap<String, Set<String>>();

        @Override
        public void close() {
            UserRolesCacheContext.clearContext();
        }
    }
}

