/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security.pam;

import com.dataiku.dip.security.pam.PAMService;
import com.dataiku.dip.security.pam.PamCredentialsAuthenticator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.server.services.PubSubService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GHPamCredentialsAuthenticator
extends PamCredentialsAuthenticator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

    @Autowired
    public GHPamCredentialsAuthenticator(PAMService pamService, GeneralSettingsDAO gsDAO, PubSubService pubSubService) {
        super(pamService);
        this.pamSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().pamSettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = gsDAO.getUnsafeAutoTXN();
                this.pamSettings = generalSettings.pamSettings;
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }
}

