/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit.targets;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.common.rpc.NoAuthAPIClient;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.model.EventServerTargetSettings;
import com.dataiku.dip.security.audit.targets.AuditTarget;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class EventServerTarget
extends AuditTarget {
    private DKULogger logger = DKULogger.getLogger((String)"dku.auditmechanism.eventserver.main");
    private DKULogger queueLogger = DKULogger.getLogger((String)"dku.auditmechanism.eventserver.queue");
    private boolean noop;
    private String instanceName;
    private String nodeType;
    private InternalAPIClient apiClient;
    private final EventServerTargetSettings settings;
    private QueueSender sender = new QueueSender();
    private volatile boolean shutdown;
    private LinkedBlockingQueue<AuditObj> inQueue = new LinkedBlockingQueue(DKUApp.getProperty("dku.eventserver.queue.size", 500));

    public EventServerTarget(EventServerTargetSettings inputSettings, @Nullable NodesDirectory directory, @Nullable String nodeType, @Nullable String instanceName) {
        this.instanceName = instanceName;
        this.nodeType = nodeType;
        this.logger.info((Object)"Building an EventServerTarget");
        if (inputSettings.autoconfigureFromNodesDirectory) {
            this.settings = (EventServerTargetSettings)JSON.deepCopy((Object)inputSettings);
            this.baseSettings = this.settings;
            this.logger.info((Object)"Autoconfiguring eventserver target from nodes directory");
            if (directory == null) {
                throw new RuntimeException("The nodes directory is not accessible");
            }
            NodesDirectory.NodeRef currentNode = directory.getCurrentNode();
            if (directory.eventServerNodeId == null) {
                this.logger.warn((Object)"The nodes directory does not have an event server configured, disabling reporting to event server");
                this.noop = true;
                return;
            }
            NodesDirectory.NodeRef esNode = directory.getById(directory.eventServerNodeId).orElseThrow(() -> new RuntimeException("Event server node not in directory"));
            if (esNode.url == null) {
                this.logger.warn((Object)"The event server node does not (yet) have an URL, disabling reporting to event server");
                this.noop = true;
                return;
            }
            this.settings.routingKeyMode = EventServerTargetSettings.RoutingKeyMode.STATIC_IF_MISSING;
            this.settings.routingKey = "node-" + currentNode.nodeId;
            this.settings.url = esNode.url;
            this.settings.authKey = currentNode.eventServerAuthKey;
            this.settings.trustAllSSLCertificates = true;
            this.logger.info((Object)("Done configuring, authkey: " + this.settings.authKey));
        } else {
            this.settings = inputSettings;
            this.baseSettings = this.settings;
        }
        this.apiClient = StringUtils.isBlank((String)this.settings.authKey) ? new NoAuthAPIClient(this.settings.url, this.settings.trustAllSSLCertificates) : new APIKeyAuthAPIClient(this.settings.url, this.settings.authKey, this.settings.trustAllSSLCertificates);
        this.sender.start();
    }

    @Override
    public void handle(AuditObj auditObj) {
        if (this.noop) {
            this.logger.debug((Object)"EventServer target is not active, dropping audit message");
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Main event server target thread handling " + JSON.json((Object)auditObj)));
        }
        AuditObj copy = (AuditObj)JSON.deepCopy((Object)auditObj);
        this.inQueue.add(copy);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.shutdown = true;
        this.sender.join(1000L);
    }

    public class QueueSender
    extends Thread {
        @Override
        public void run() {
            int maxEventsPerDrain = DKUApp.getProperty("dku.eventserver.queue.maxEventsPerDrain", 200);
            EventServerTarget.this.queueLogger.info((Object)"Sending queue starting");
            while (!EventServerTarget.this.shutdown) {
                DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx("dku.audit.targets.eventserver.singleLoop");
                AuditObj head = null;
                try {
                    head = EventServerTarget.this.inQueue.poll(DKUApp.getProperty("dku.eventserver.queue.timeout", 500), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    if (tctx == null) continue;
                    tctx.close();
                    continue;
                }
                try {
                    if (head == null) continue;
                    ArrayList<AuditObj> objs = new ArrayList<AuditObj>();
                    objs.add(head);
                    EventServerTarget.this.inQueue.drainTo(objs, maxEventsPerDrain);
                    if (EventServerTarget.this.queueLogger.isTraceEnabled()) {
                        EventServerTarget.this.queueLogger.trace((Object)("Sending " + objs.size() + " events to event server"));
                    }
                    long before = System.nanoTime();
                    HashMap<CallSite, JsonObject> eventsPerTopicAndRoutingKey = new HashMap<CallSite, JsonObject>();
                    for (AuditObj obj : objs) {
                        String mapKey;
                        JsonObject msg;
                        String nodeId;
                        Object routingKey = obj.routingKey;
                        if (EventServerTarget.this.settings.routingKeyMode == EventServerTargetSettings.RoutingKeyMode.STATIC) {
                            routingKey = EventServerTarget.this.settings.routingKey;
                        } else if (EventServerTarget.this.settings.routingKeyMode == EventServerTargetSettings.RoutingKeyMode.STATIC_IF_MISSING && routingKey == null) {
                            routingKey = EventServerTarget.this.settings.routingKey;
                        }
                        JsonObject event = (JsonObject)JSON.deepCopy((Object)obj.get());
                        event.addProperty("auditTopic", obj.topic);
                        if (routingKey != null) {
                            event.addProperty("auditRoutingKey", (String)routingKey);
                        }
                        if ((nodeId = DKUApp.getNodeId()) != null) {
                            event.addProperty("dssNodeId", nodeId);
                        }
                        event.addProperty("dssInstallId", DKUApp.getInstallId());
                        if (EventServerTarget.this.nodeType != null) {
                            event.addProperty("dssNodeType", EventServerTarget.this.nodeType);
                        }
                        if (EventServerTarget.this.instanceName != null) {
                            event.addProperty("dssNodeName", EventServerTarget.this.instanceName);
                        }
                        if ((msg = (JsonObject)eventsPerTopicAndRoutingKey.get(mapKey = obj.topic + "___DKU___" + (String)routingKey)) == null) {
                            msg = new JsonObject();
                            msg.addProperty("topic", obj.topic);
                            if (routingKey != null) {
                                msg.addProperty("routingKey", (String)routingKey);
                            }
                            msg.add("events", (JsonElement)new JsonArray());
                            eventsPerTopicAndRoutingKey.put((CallSite)((Object)mapKey), msg);
                        }
                        msg.get("events").getAsJsonArray().add((JsonElement)event);
                    }
                    long prepared = System.nanoTime();
                    if (EventServerTarget.this.queueLogger.isTraceEnabled()) {
                        EventServerTarget.this.queueLogger.traceV("Splitted %d events into %d sends", new Object[]{objs.size(), eventsPerTopicAndRoutingKey.size()});
                    }
                    for (JsonObject msg : eventsPerTopicAndRoutingKey.values()) {
                        try {
                            DSSMetrics.TimeCtx tctx2 = DSSMetrics.timeCtx("dku.audit.targets.eventserver.postEvents");
                            try {
                                EventServerTarget.this.apiClient.postObject("/events", 30000, Void.class, (Object)msg);
                            }
                            finally {
                                if (tctx2 == null) continue;
                                tctx2.close();
                            }
                        }
                        catch (Exception e) {
                            EventServerTarget.this.queueLogger.warn((Object)"Failed to post events to event server", (Throwable)e);
                        }
                    }
                    long done = System.nanoTime();
                    if (EventServerTarget.this.queueLogger.isTraceEnabled()) {
                        EventServerTarget.this.queueLogger.traceV("Sent %d events to event server. Prepare=%dus Send=%dus", new Object[]{objs.size(), (prepared - before) / 1000L, (done - prepared) / 1000L});
                    }
                    DSSMetrics.registry().meter("dku.audit.targets.eventserver.processedMessages").mark((long)objs.size());
                    DSSMetrics.registry().meter("dku.audit.targets.eventserver.processedSends").mark((long)eventsPerTopicAndRoutingKey.size());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (tctx == null) continue;
                    tctx.close();
                }
            }
            EventServerTarget.this.logger.info((Object)"Sender thread shutting down");
        }
    }
}

