/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.jwt;

import com.dataiku.dip.coremodel.InfoMessage;

public enum JWTError implements InfoMessage.MessageCode
{
    ERR_JWT_TOKEN_INVALID_FORMAT("Token invalid format", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
    ERR_JWT_INVALID_SIGNATURE("JWT signature is invalid", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_JWT_NO_EXPIRED_TIME("JWT has no expiration time", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_JWT_EXPIRED("JWT expired", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_JWT_IAT_INVALID("JWT invalid IAT", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_JWT_NBT_INVALID("JWT invalid NBT", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_JWT_INVALID_ISSUER("JWT invalid issuer", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_JWT_INVALID_AUDIENCE("JWT invalid audience", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_JWT_ALGO_NOT_SUPPORTED("JWT signature algorithm is not supported", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_JWK_NOT_FOUND("JWK not found", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY);

    private final String title;
    private final InfoMessage.FixabilityCategory fixability;

    private JWTError(String title, InfoMessage.FixabilityCategory fixability) {
        this.title = title;
        this.fixability = fixability;
    }

    public String getCode() {
        return this.name();
    }

    public String getCodeTitle() {
        return this.title;
    }

    public InfoMessage.FixabilityCategory getFixability() {
        return this.fixability;
    }
}

