/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.auth.UserNotFoundException;
import com.dataiku.dip.security.ldap.LdapGroup;
import com.dataiku.dip.security.ldap.LdapSettings;
import com.dataiku.dip.security.ldap.LdapUser;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import java.io.Closeable;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.CursorLdapReferralException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.filter.FilterEncoder;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;

public class LdapUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.ldap");

    public static class Connection
    implements Closeable {
        ConnectionParams params;
        LdapConnection connection;
        boolean adminLogged;

        public Connection(ConnectionParams params) throws IOException {
            this.params = params;
            logger.info((Object)"Connecting to server");
            LdapConnectionConfig config = new LdapConnectionConfig();
            config.setLdapHost(params.host);
            config.setUseSsl(params.useSsl);
            config.setUseTls(params.useTls);
            if (params.trustAllCertificates) {
                config.setTrustManagers(new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }});
            }
            if (params.port != -1) {
                config.setLdapPort(params.port);
            } else {
                config.setLdapPort(params.useSsl ? config.getDefaultLdapsPort() : config.getDefaultLdapPort());
            }
            if (params.bindDN != null) {
                config.setName(params.bindDN);
                if (params.bindPassword != null) {
                    config.setCredentials(params.bindPassword);
                }
            }
            this.connection = new LdapNetworkConnection(config);
            this.connection.setTimeOut(params.timeout);
            try {
                this.connection.bind();
            }
            catch (LdapAuthenticationException e) {
                logger.warn((Object)"LDAP authentication failed", (Throwable)e);
                this.connection.close();
                throw new IOException("LDAP authentication failed: " + e.getMessage(), e);
            }
            catch (LdapException e) {
                logger.warn((Object)"error binding to the LDAP server", (Throwable)e);
                this.connection.close();
                throw new IOException("error binding to the LDAP server: " + e.getMessage(), e);
            }
            this.adminLogged = true;
        }

        @Override
        public void close() throws IOException {
            this.connection.close();
        }

        public Set<LdapUser> getAllUsers() throws IOException {
            try {
                if (!this.adminLogged) {
                    this.connection.bind();
                    this.adminLogged = true;
                }
                logger.info((Object)"Getting all users ");
                ArrayList<String> fields = new ArrayList<String>();
                if (this.params.displayNameAttribute != null) {
                    fields.add(this.params.displayNameAttribute);
                }
                if (this.params.emailAttribute != null) {
                    fields.add(this.params.emailAttribute);
                }
                if (this.params.usernameAttribute != null) {
                    fields.add(this.params.usernameAttribute);
                }
                ArrayList<Entry> entries = new ArrayList<Entry>();
                try (EntryCursor cursor = this.connection.search(this.params.userSearchBase, this.params.allUsersFilter, this.params.userSearchScope, fields.toArray(new String[0]));){
                    while (cursor.next()) {
                        try {
                            Entry u = (Entry)cursor.get();
                            if (u == null) {
                                break;
                            }
                            entries.add(u);
                        }
                        catch (CursorLdapReferralException e) {
                            logger.debug((Object)("Ignoring user referral: " + e.getReferralInfo()));
                        }
                    }
                }
                catch (CursorException e) {
                    logger.warn((Object)"Error retrieving users", (Throwable)e);
                    throw new IOException(e);
                }
                HashSet<LdapUser> ldapUsers = new HashSet<LdapUser>();
                for (Entry entry : entries) {
                    Attribute attr;
                    LdapUser ldapUser = new LdapUser();
                    Attribute username = entry.get(this.params.usernameAttribute);
                    if (username != null && username.isHumanReadable()) {
                        ldapUser.username = username.getString();
                    }
                    ldapUser.dn = entry.getDn();
                    if (this.params.displayNameAttribute != null && (attr = entry.get(this.params.displayNameAttribute)) != null && attr.isHumanReadable()) {
                        ldapUser.displayName = attr.getString();
                    }
                    if (this.params.emailAttribute != null && (attr = entry.get(this.params.emailAttribute)) != null && attr.isHumanReadable()) {
                        ldapUser.email = attr.getString();
                    }
                    ldapUser.groups = new HashSet<String>();
                    ldapUsers.add(ldapUser);
                }
                return ldapUsers;
            }
            catch (IOException | LdapException e) {
                logger.warn((Object)"Error retrieving users", e);
                throw new IOException(e);
            }
        }

        public Set<LdapGroup> getAllGroups() throws IOException {
            HashSet<LdapGroup> hashSet;
            block19: {
                Validate.notBlank((CharSequence)this.params.groupSearchBase, (String)"LDAP server URL is not set", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)this.params.allGroupsFilter, (String)"LDAP all groups filter is not set", (Object[])new Object[0]);
                Validate.notNull((Object)this.params.groupSearchScope);
                Validate.notBlank((CharSequence)this.params.groupNameAttribute, (String)"LDAP group name attribute is not set", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)this.params.groupMembershipAttribute, (String)"LDAP group membership attribute is not set", (Object[])new Object[0]);
                if (!this.adminLogged) {
                    this.connection.bind();
                    this.adminLogged = true;
                }
                logger.info((Object)"Querying all groups");
                EntryCursor cursor = this.connection.search(this.params.groupSearchBase, this.params.allGroupsFilter, this.params.groupSearchScope, new String[]{this.params.groupNameAttribute, this.params.groupMembershipAttribute});
                try {
                    HashSet<LdapGroup> ldapGroups = new HashSet<LdapGroup>();
                    while (cursor.next()) {
                        try {
                            Entry entry = (Entry)cursor.get();
                            if (entry == null) continue;
                            try {
                                Attribute groupName = entry.get(this.params.groupNameAttribute);
                                if (groupName == null || !groupName.isHumanReadable()) continue;
                                HashSet<String> members = new HashSet<String>();
                                Attribute membership = entry.get(this.params.groupMembershipAttribute);
                                if (membership != null) {
                                    membership.forEach(member -> members.add(member.getString()));
                                }
                                ldapGroups.add(new LdapGroup(groupName.getString(), members));
                            }
                            catch (LdapInvalidAttributeValueException e) {
                                logger.errorV("Attribute '%s' of '%s' entry is not a String", new Object[]{this.params.groupMembershipAttribute, entry.getDn()});
                            }
                            catch (IllegalArgumentException e) {
                                logger.error((Object)"Could not create LDAP group", (Throwable)e);
                            }
                        }
                        catch (CursorLdapReferralException e) {
                            logger.debug((Object)("Ignoring group referral: " + e.getReferralInfo()));
                        }
                    }
                    Connection.warnIfLdapOperationError(cursor);
                    hashSet = ldapGroups;
                    if (cursor == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (cursor != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (CursorException e) {
                            logger.warn((Object)"Error retrieving groups ", (Throwable)e);
                            throw new IOException(e);
                        }
                    }
                    catch (LdapException e) {
                        throw new IOException(e);
                    }
                }
                cursor.close();
            }
            return hashSet;
        }

        private static void warnIfLdapOperationError(EntryCursor cursor) {
            LdapResult ldapResult;
            ResultCodeEnum code;
            SearchResultDone resultDone = cursor.getSearchResultDone();
            if (resultDone != null && (code = (ldapResult = resultDone.getLdapResult()).getResultCode()) != ResultCodeEnum.SUCCESS) {
                logger.warn((Object)("LDAP search returned code " + String.valueOf(code) + " message " + ldapResult.getDiagnosticMessage() + "\n" + String.valueOf(ldapResult)));
            }
        }

        public LDAPTestResult test() throws IOException {
            String[] attributes = new String[]{"vendorName", "vendorVersion", "dnsHostName", "dsaName"};
            LDAPTestResult result = new LDAPTestResult();
            try {
                Entry e = this.connection.getRootDse(attributes);
                for (String s : attributes) {
                    Attribute attr = e.get(s);
                    if (attr == null || !attr.isHumanReadable()) continue;
                    result.serverInfo = result.serverInfo + s + ": " + attr.getString() + "\n";
                }
            }
            catch (LdapException e) {
                logger.warn((Object)"error querying the LDAP server", (Throwable)e);
                throw new IOException(e);
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public LdapUser lookupUser(String username) throws IOException {
            try {
                Attribute attr;
                if (!this.adminLogged) {
                    this.connection.bind();
                    this.adminLogged = true;
                }
                logger.info((Object)("Searching user " + username));
                ArrayList<String> fields = new ArrayList<String>();
                if (this.params.displayNameAttribute != null) {
                    fields.add(this.params.displayNameAttribute);
                }
                if (this.params.emailAttribute != null) {
                    fields.add(this.params.emailAttribute);
                }
                Entry u = null;
                try (EntryCursor cursor = this.connection.search(this.params.userSearchBase, this.params.userSearchFilter.replace("{USERNAME}", FilterEncoder.encodeFilterValue((String)username)), this.params.userSearchScope, fields.toArray(new String[0]));){
                    while (cursor.next()) {
                        try {
                            u = (Entry)cursor.get();
                            break;
                        }
                        catch (CursorLdapReferralException e) {
                            logger.debug((Object)("Ignoring user referral: " + e.getReferralInfo()));
                        }
                    }
                    if (u == null) {
                        Connection.warnIfLdapOperationError(cursor);
                        logger.info((Object)("User " + username + " not found"));
                        LdapUser e = null;
                        return e;
                    }
                }
                assert (u != null);
                LdapUser result = new LdapUser();
                result.username = username;
                result.dn = u.getDn();
                if (this.params.groupSearchBase != null) {
                    result.groups = this.getUserGroups(username, u.getDn());
                    logger.info((Object)("Fetched groups " + JSON.json(result.groups)));
                    if (this.params.authorizedGroups != null) {
                        boolean authorized = false;
                        for (String g : this.params.authorizedGroups) {
                            if (!result.groups.contains(g)) continue;
                            authorized = true;
                            break;
                        }
                        if (!authorized) {
                            logger.info((Object)("User " + username + " is not authorized to connect. User groups='" + JSON.json(result.groups) + "' vs authorized groups='" + JSON.json(this.params.authorizedGroups) + "'"));
                            return null;
                        }
                    }
                } else {
                    result.groups = new HashSet<String>();
                }
                if (this.params.displayNameAttribute != null && (attr = u.get(this.params.displayNameAttribute)) != null && attr.isHumanReadable()) {
                    result.displayName = attr.getString();
                }
                if (this.params.emailAttribute == null) return result;
                Attribute attr2 = u.get(this.params.emailAttribute);
                if (attr2 == null) return result;
                if (!attr2.isHumanReadable()) return result;
                result.email = attr2.getString();
                return result;
            }
            catch (LdapException e) {
                logger.warn((Object)("Error retrieving user " + username), (Throwable)e);
                throw new IOException(e);
            }
        }

        private Set<String> getUserGroups(String username, Dn userDn) throws LdapException, IOException {
            if (!this.adminLogged) {
                this.connection.bind();
                this.adminLogged = true;
            }
            logger.info((Object)("Querying groups for " + String.valueOf(userDn)));
            try (EntryCursor cursor = this.connection.search(this.params.groupSearchBase, this.params.groupSearchFilter.replace("{USERNAME}", FilterEncoder.encodeFilterValue((String)username)).replace("{USERDN}", FilterEncoder.encodeFilterValue((String)userDn.toString())), this.params.groupSearchScope, new String[]{this.params.groupNameAttribute});){
                HashSet<String> groups = new HashSet<String>();
                while (cursor.next()) {
                    try {
                        Entry g = (Entry)cursor.get();
                        Attribute attr = g.get(this.params.groupNameAttribute);
                        if (attr == null || !attr.isHumanReadable()) continue;
                        groups.add(attr.getString());
                    }
                    catch (CursorLdapReferralException e) {
                        logger.debug((Object)("Ignoring group referral: " + e.getReferralInfo()));
                    }
                }
                Connection.warnIfLdapOperationError(cursor);
                HashSet<String> hashSet = groups;
                return hashSet;
            }
        }

        private boolean validatePassword(Dn dn, String password) throws IOException {
            logger.info((Object)("Validating password for " + String.valueOf(dn)));
            if (StringUtils.isBlank((String)password)) {
                logger.warn((Object)("Empty password passed for " + String.valueOf(dn) + ", password validation rejected"));
                return false;
            }
            try {
                this.adminLogged = false;
                this.connection.bind(dn, password);
                return true;
            }
            catch (LdapAuthenticationException e) {
                logger.warn((Object)("Password validation failed for " + String.valueOf(dn)));
                return false;
            }
            catch (LdapException e) {
                logger.warn((Object)("Error checking password for user " + String.valueOf(dn)));
                throw new IOException(e);
            }
        }

        public LdapUser lookupUser(String username, String password) throws IOException, UserNotFoundException {
            LdapUser user = this.lookupUser(username);
            if (user == null) {
                throw new UserNotFoundException("User not found");
            }
            if (!this.validatePassword(user.dn, password)) {
                return null;
            }
            return user;
        }

        public class LDAPTestResult {
            public String serverInfo = "";
        }
    }

    public static class ConnectionParams {
        String host;
        int port = -1;
        boolean useSsl;
        boolean useTls;
        boolean trustAllCertificates = true;
        String bindDN;
        String bindPassword;
        String userSearchBase;
        String userSearchFilter = "(&(objectClass=posixAccount)(uid={USERNAME}))";
        SearchScope userSearchScope = SearchScope.SUBTREE;
        String groupSearchBase;
        String groupSearchFilter = "(&(objectClass=posixGroup)(memberUid={USERNAME}))";
        SearchScope groupSearchScope = SearchScope.SUBTREE;
        String groupNameAttribute = "cn";
        String displayNameAttribute = "cn";
        String emailAttribute = "mail";
        String userProfile;
        List<String> authorizedGroups;
        String usernameAttribute;
        String groupMembershipAttribute;
        String allGroupsFilter;
        String allUsersFilter;
        public static final String USERNAME_PLACEHOLDER = "{USERNAME}";
        public static final String MAIL_PLACEHOLDER = "{MAIL}";
        public static final String USERDN_PLACEHOLDER = "{USERDN}";
        public final long timeout = 10000L;

        public ConnectionParams(LdapSettings settings, PasswordEncryptionService cryptoService) {
            LdapUrl url;
            if (!settings.enabled) {
                throw ErrorContext.iae((String)"LDAP authentication not enabled");
            }
            if (StringUtils.isBlank((String)settings.url)) {
                throw ErrorContext.iae((String)"Missing LDAP url");
            }
            try {
                url = new LdapUrl(settings.url);
            }
            catch (LdapURLEncodingException e) {
                throw ErrorContext.iae((String)"Invalid LDAP url", (Exception)((Object)e));
            }
            this.host = url.getHost();
            this.port = url.getPort();
            this.useSsl = url.getScheme().equalsIgnoreCase("ldaps://");
            if (url.getDn() == null) {
                throw ErrorContext.iae((String)"Invalid LDAP url: missing base DN");
            }
            this.useTls = settings.useTls;
            if (this.useTls && this.useSsl) {
                throw ErrorContext.iae((String)"Cannot use TLS on a LDAPS url");
            }
            this.trustAllCertificates = settings.trustAllCertificates;
            if (!StringUtils.isBlank((String)settings.bindDN)) {
                this.bindDN = settings.bindDN;
                if (!StringUtils.isBlank((String)settings.bindPassword)) {
                    settings.decryptFields(cryptoService);
                    this.bindPassword = settings.bindPassword;
                }
            } else if (!StringUtils.isBlank((String)settings.bindPassword)) {
                throw ErrorContext.iae((String)"bind password without bind DN");
            }
            this.userSearchBase = url.getDn().toString();
            if (StringUtils.isBlank((String)settings.userFilter)) {
                throw ErrorContext.iae((String)"missing user filter");
            }
            this.userSearchFilter = settings.userFilter;
            if (!this.userSearchFilter.contains(USERNAME_PLACEHOLDER)) {
                throw ErrorContext.iae((String)"missing {USERNAME} in user filter");
            }
            try {
                FilterParser.parse((String)this.userSearchFilter.replace(USERNAME_PLACEHOLDER, "dkutest"), (boolean)true);
            }
            catch (ParseException e) {
                throw ErrorContext.iae((String)("invalid user filter: " + e.getMessage()));
            }
            this.displayNameAttribute = StringUtils.isBlank((String)settings.displayNameAttribute) ? null : settings.displayNameAttribute;
            String string = this.emailAttribute = StringUtils.isBlank((String)settings.emailAttribute) ? null : settings.emailAttribute;
            if (settings.enableGroups) {
                this.groupSearchBase = url.getDn().toString();
                if (StringUtils.isBlank((String)settings.groupFilter)) {
                    throw ErrorContext.iae((String)"missing group filter");
                }
                this.groupSearchFilter = settings.groupFilter;
                if (!this.groupSearchFilter.contains(USERNAME_PLACEHOLDER) && !this.groupSearchFilter.contains(USERDN_PLACEHOLDER)) {
                    throw ErrorContext.iae((String)"missing {USERNAME} or {USERDN} in group filter");
                }
                try {
                    FilterParser.parse((String)this.groupSearchFilter.replace(USERNAME_PLACEHOLDER, "dkutest").replace(USERDN_PLACEHOLDER, "cn=dkutest,dc=dkutest"), (boolean)true);
                }
                catch (ParseException e) {
                    throw ErrorContext.iae((String)("invalid group filter: " + e.getMessage()));
                }
                if (StringUtils.isBlank((String)settings.groupNameAttribute)) {
                    throw ErrorContext.iae((String)"missing group name attribute");
                }
                this.groupNameAttribute = settings.groupNameAttribute;
                this.allGroupsFilter = settings.allGroupsFilter;
                this.groupMembershipAttribute = settings.groupMembershipAttribute;
            }
            this.allUsersFilter = settings.allUsersFilter;
            this.usernameAttribute = settings.usernameAttribute;
        }
    }
}

