/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.util;

import com.dataiku.dss.shadelibpoi.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.internal.InvalidZipException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.util.ZipArchiveFakeEntry;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.util.ZipArchiveThresholdInputStream;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.util.ZipEntrySource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class ZipInputStreamZipEntrySource
implements ZipEntrySource {
    private static int thresholdForTempFiles = -1;
    private static boolean encryptTempFiles = false;
    private final Map<String, ZipArchiveFakeEntry> zipEntries = new HashMap<String, ZipArchiveFakeEntry>();
    private InputStream streamToClose;

    public static void setThresholdBytesForTempFiles(int thresholdBytes) {
        thresholdForTempFiles = thresholdBytes;
    }

    public static int getThresholdBytesForTempFiles() {
        return thresholdForTempFiles;
    }

    public static void setEncryptTempFiles(boolean encrypt) {
        encryptTempFiles = encrypt;
    }

    public static boolean shouldEncryptTempFiles() {
        return encryptTempFiles;
    }

    public ZipInputStreamZipEntrySource(ZipArchiveThresholdInputStream inp) throws IOException {
        ZipArchiveEntry zipEntry;
        HashSet<String> filenames = new HashSet<String>();
        while ((zipEntry = inp.getNextEntry()) != null) {
            String name = zipEntry.getName();
            if (name == null || name.isEmpty()) {
                throw new InvalidZipException("Input file contains an entry with an empty name");
            }
            if (filenames.contains(name = name.toLowerCase(Locale.ROOT))) {
                throw new InvalidZipException("Input file contains more than 1 entry with the name " + zipEntry.getName());
            }
            filenames.add(name);
            this.zipEntries.put(name, new ZipArchiveFakeEntry(zipEntry, inp));
        }
        this.streamToClose = inp;
    }

    @Override
    public Enumeration<? extends ZipArchiveEntry> getEntries() {
        return Collections.enumeration(this.zipEntries.values());
    }

    @Override
    public InputStream getInputStream(ZipArchiveEntry zipEntry) throws IOException {
        assert (zipEntry instanceof ZipArchiveFakeEntry);
        return ((ZipArchiveFakeEntry)zipEntry).getInputStream();
    }

    @Override
    public void close() throws IOException {
        for (ZipArchiveFakeEntry entry : this.zipEntries.values()) {
            entry.close();
        }
        this.zipEntries.clear();
        this.streamToClose.close();
    }

    @Override
    public boolean isClosed() {
        return this.zipEntries.isEmpty();
    }

    @Override
    public ZipArchiveEntry getEntry(String path) {
        String normalizedPath = path.replace('\\', '/');
        ZipArchiveEntry ze = this.zipEntries.get(normalizedPath);
        if (ze != null) {
            return ze;
        }
        for (Map.Entry<String, ZipArchiveFakeEntry> fze : this.zipEntries.entrySet()) {
            if (!normalizedPath.equalsIgnoreCase(fze.getKey())) continue;
            return fze.getValue();
        }
        return null;
    }
}

