(function() {
    'use strict';
    const app = angular.module('dataiku.homepage');

    app.component('workspacesRowEmptyState', { // workspaces-row-empty-state
        templateUrl: 'static/dataiku/homepage/empty-states/variants/workspaces-row-empty-state.html',
        controller: function ($scope, translate) {
            $scope.translate = translate;
        }
    });

    app.component('applicationsRowEmptyState', { // applications-row-empty-state
        templateUrl: 'static/dataiku/homepage/empty-states/variants/applications-row-empty-state.html',
        controller: function ($scope, translate) {
            $scope.translate = translate;
        }
    });

    app.component('projectFoldersRowEmptyState', { // project-folders-row-empty-state
        templateUrl: 'static/dataiku/homepage/empty-states/variants/project-folders-row-empty-state.html',
        controller: function ($scope, translate) {
            $scope.translate = translate;
        }
    });

    app.component('projectsRowEmptyState', { // projects-row-empty-state
        templateUrl: 'static/dataiku/homepage/empty-states/variants/projects-row-empty-state.html',
        controller: function($rootScope, homepageService, $scope, translate) {
            const ctrl = this;
            $scope.translate = translate;
            const gp = $rootScope.appConfig.globalPermissions;

            ctrl.ctaMode = gp.mayCreateProjects ? 'tiles' // for automation nodes, tiles may be selected, but they are not displayed
                : gp.mayCreateProjectsFromMacros ? 'can-with-macros'
                : gp.mayCreateProjectsFromTemplates ? 'learning-only'
                : 'not-authorized';

            ctrl.newProject = () => homepageService.newProject($scope);
            ctrl.newTutorial = () => homepageService.newTutorial($scope);
            ctrl.importProject = () => homepageService.importProject($scope);
        }
    });

})();
