(function(){
'use strict';
const app = angular.module('dataiku.retrieval-augmented-llm', ['dataiku.ml.report', 'dataiku.lambda']);

app.controller("_RetrievalAugmentedLLMSavedModelController", function($scope, $rootScope, $state, $controller, $stateParams, $q, DataikuAPI, Dialogs, DKUtils, ActiveProjectKey, FullModelLikeIdUtils, SmartId) {
    $controller("_SavedModelReportController", {$scope});

    DataikuAPI.savedmodels.llmCommon.getStatus(ActiveProjectKey.get(), $stateParams.smId).success(function(data){
        $scope.fillVersionSelectorStuff(data);
    }).catch(setErrorInScope.bind($scope));

    DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey, "GENERIC_COMPLETION").then(function({data}) {
        $scope.availableAugmentableLLMs = data.identifiers.filter(id => id.type !== "RETRIEVAL_AUGMENTED" && id.type !== "SAVED_MODEL_AGENT");
    }).catch(setErrorInScope.bind($scope));

    DataikuAPI.pretrainedModels.listAvailableLLMs($stateParams.projectKey, "TEXT_EMBEDDING_EXTRACTION").then(function({data}) {
        $scope.availableEmbeddingModels = data.identifiers;
    }).catch(setErrorInScope.bind($scope));

    const currentVersionId = FullModelLikeIdUtils.parse($stateParams.fullModelId).versionId;
    $scope.currentVersionId = currentVersionId;

    $scope.$watch("savedModel", function(nv) {
        if (!nv) return;

        $scope.currentVersionIdx = nv.inlineVersions.findIndex(v => v.versionId === currentVersionId);
        if ($scope.currentVersionIdx < 0) {
            return;
        }
        $scope.currentlySavedInlineModel = angular.copy(nv.inlineVersions[$scope.currentVersionIdx]);
        $scope.currentVersionData = nv.inlineVersions[$scope.currentVersionIdx];

        $scope.ragllmSettings = $scope.currentVersionData.ragllmSettings;

        $scope.getMetadataColumns = function() {
            const schema = $scope.retrievableKnowledge?.metadataColumnsSchema ?? [];
            const multimodalColumn = $scope.retrievableKnowledge?.multimodalColumn;

            return schema.map(sc => sc.name)
                .filter(col => col !== multimodalColumn);
        };

        DataikuAPI.retrievableknowledge.getFullInfo(ActiveProjectKey.get(), SmartId.create($scope.ragllmSettings.kbRef, $stateParams.projectKey)).then(function({ data }) {
            $scope.rkFullInfo = data;
            $scope.retrievableKnowledge = data.retrievableKnowledge;
            if (data.retrievableKnowledge.vectorStoreType === 'VERTEX_AI_GCS_BASED') {
                $scope.ragllmSettings.enforceDocumentLevelSecurity = false;
            }
            $scope.metadataColumns = $scope.getMetadataColumns();
        }).catch(setErrorInScope.bind($scope));

        DataikuAPI.retrievableknowledge.getCurrentVersionInfo($stateParams.projectKey, $scope.ragllmSettings.kbRef)
            .then(function({ data }) {
                $scope.embeddingRecipeDesc = data.embeddingRecipeParams;
                $scope.isRkBuilt = data.isBuilt;
            }).catch(setErrorInScope.bind($scope));
    });

    $scope.save = function() {
        if (!$scope.isDirty()) {
            return $q.when('retrieval-augmented LLM not dirty');
        }

        const deferred = $q.defer();
        const saveAfterConflictCheck = function() {
            DataikuAPI.savedmodels.retrievalAugmentedLLMs.save($scope.savedModel, $scope.currentVersionId).success(function(data) {
                $scope.savedModel = data;
                $scope.currentlySavedInlineModel = angular.copy($scope.savedModel.inlineVersions[$scope.currentVersionIdx]);
                deferred.resolve('retrieval-augmented LLM saved');
            }, () => deferred.reject());
        };

        DataikuAPI.savedmodels.retrievalAugmentedLLMs.checkSaveConflict($scope.savedModel).success(function(conflictResult) {
            if (!conflictResult.canBeSaved) {
                Dialogs.openConflictDialog($scope, conflictResult).then(
                    function(resolutionMethod) {
                        if (resolutionMethod === 'erase') {
                            saveAfterConflictCheck();
                        } else if (resolutionMethod === 'ignore') {
                            deferred.reject();
                            DKUtils.reloadState();
                        }
                    }
                );
            } else {
                saveAfterConflictCheck();
            }
        }).error(setErrorInScope.bind($scope));

        return deferred.promise;
    };
    $rootScope.saveRetrievalAugmentedModel = $scope.save;

    $scope.saveIgnoringQuickTestQuery = function() {
        if (!$scope.isDirty()) {
            return $q.when('retrieval-augmented LLM not dirty');
        }

        if (!$scope.isConfigDirty()) {
            return $q.when('only difference is the quicktest query, not saving');
        }

        return $scope.save();
    };

    $scope.isConfigDirty = function() {
        let frankenVersion = angular.copy($scope.currentlySavedInlineModel);
        frankenVersion["quickTestQuery"] = $scope.savedModel.inlineVersions[$scope.currentVersionIdx]["quickTestQuery"];

        return !angular.equals(frankenVersion, $scope.savedModel.inlineVersions[$scope.currentVersionIdx]);
    };

    $scope.isDirty = function() {
        if (!$scope.savedModel) return false;
        return !angular.equals($scope.savedModel.inlineVersions[$scope.currentVersionIdx], $scope.currentlySavedInlineModel);
    };
    $rootScope.retrievalAugmentedModelIsDirty = $scope.isDirty;

    checkChangesBeforeLeaving($scope, $scope.isDirty);
});

app.controller("RetrievalAugmentedLLMSavedModelDesignController", function($scope, $rootScope, $state, $stateParams, $controller, ActivityIndicator, DataikuAPI, PluginConfigUtils, PluginsService, TopNav, CreateModalFromTemplate) {
    $controller("_RetrievalAugmentedLLMSavedModelController", {$scope});

    // Keep in sync with RAGLLMSettings.DEFAULT_CONTEXT_MESSAGE
    $scope.defaultPrompt = "Use the following pieces of context to answer the question at the end.\n"
                           + "If you do not know the answer, just say that you do not know, do not try to make up an answer.";

    // Keep in sync with RAGLLMSettings.SearchInputStrategySettings.DEFAULT_REWRITE_PROMPT
    $scope.defaultRewritePrompt = "When a message requires document retrieval, rewrite it to optimize retrieval from the vector store.\n"
                                  + "Focus on clarity, disambiguation, and extracting the core intent.\n"
                                  + "Output only the rewritten query. Do not include comments or tips.";

    $scope.$watch("savedModel", (nv) => {
        if (!nv) return;

        if (!$scope.noSetLoc) {
            TopNav.setLocation(TopNav.TOP_GENAI_MODELS, TopNav.LEFT_GENAI_MODELS, "RETRIEVAL-AUGMENTED_LLM-SAVED_MODEL-VERSION", "design");
        }
    });

    $scope.openTestInPromptStudioModal = function () {
        CreateModalFromTemplate('/templates/savedmodels/retrieval-augmented-llm/test-in-prompt-studio.html', $scope, 'TestInPromptStudioModalController');
    };

    $scope.hasMetadataColumns = function() {
        const schema = $scope.retrievableKnowledge?.metadataColumnsSchema ?? [];
        return schema.length > 0;
    };

    $scope.disableTextGuardrails = function (ragllmSettings) {
        ragllmSettings.ragSpecificGuardrails.faithfulnessSettings.enabled = false;
        ragllmSettings.ragSpecificGuardrails.relevancySettings.enabled = false;
    }

    $scope.disableMultimodalGuardrails = function (ragllmSettings) {
        ragllmSettings.ragSpecificGuardrails.multimodalFaithfulnessSettings.enabled = false;
        ragllmSettings.ragSpecificGuardrails.multimodalRelevancySettings.enabled = false;
    }

    $scope.getParentRecipeHref = function () {
        return $state.href('projects.project.recipes.recipe', {projectKey: $scope.rkFullInfo.creatingRecipe.projectKey, recipeName: $scope.rkFullInfo.creatingRecipe.name});
    }
});

app.controller("RetrievalAugmentedLLMSavedModelSettingsController", function($scope, $state, $controller, DataikuAPI, TopNav) {
    $controller("_RetrievalAugmentedLLMSavedModelController", { $scope });

    $scope.$watch("savedModel", (nv) => {
        if (!nv) return;

        if (!$scope.noSetLoc) {
            TopNav.setLocation(TopNav.TOP_GENAI_MODELS, TopNav.LEFT_GENAI_MODELS, "RETRIEVAL-AUGMENTED_LLM-SAVED_MODEL-VERSION", "settings");
        }
        const currentVersion = nv.inlineVersions.find(v => v.versionId===nv.activeVersion);
        $scope.completionSettings = currentVersion.ragllmSettings?.completionSettings;
        // needed for getting the temperature ranges of the LLM
        DataikuAPI.pretrainedModels.listAvailableLLMs($state.projectKey, "GENERIC_COMPLETION").success(function(data) {
            if (currentVersion.ragllmSettings.llmId && data.identifiers) {
                $scope.activeLLM = data.identifiers.find(l => l.id === currentVersion.ragllmSettings.llmId);
            }
        }).error(setErrorInScope.bind($scope));

    });

    $scope.getKnowledgeBankSettingsHref = function() {
        if (!$scope.retrievableKnowledge) {
            return "";
        }
        const { projectKey, id } = $scope.retrievableKnowledge;
        return $state.href("projects.project.retrievableknowledges.retrievableknowledge.settings", {
            projectKey,
            retrievableKnowledgeId: id,
            '#': 'core-settings',
        });
    }
});

app.controller("RetrievalAugmentedLLMSavedModelHistoryController", function($scope, $controller, TopNav) {
    $controller("_RetrievalAugmentedLLMSavedModelController", { $scope });
    TopNav.setLocation(TopNav.TOP_GENAI_MODELS, TopNav.LEFT_GENAI_MODELS, "RETRIEVAL-AUGMENTED_LLM-SAVED_MODEL-VERSION", "history");
});

/* ***************************** Test In Prompt Studio Modal ************************** */

app.controller('TestInPromptStudioModalController', function ($scope, $stateParams, $state, DataikuAPI) {
    $scope.prompt = {};

    DataikuAPI.promptStudios
        .listHeads($stateParams.projectKey)
        .then(function ({ data }) {
            const createOption = { createOption: true, name: 'Create a new Prompt studio...' };
            $scope.promptStudios = data;
            $scope.promptStudios.unshift(createOption);
            $scope.prompt.studio = createOption;
            $scope.prompt.newPromptName = '';
            return;
        })
        .catch(setErrorInScope.bind($scope));

    $scope.editInStudio = function () {
        const promptCreationSettings = {};
        if ($scope.prompt.studio.createOption) {
            promptCreationSettings.newPromptStudioName = $scope.prompt.newPromptName;
        } else {
            promptCreationSettings.promptStudioId = $scope.prompt.studio.id;
        }

        $scope.saveRetrievalAugmentedModel(true).then(function () {
            DataikuAPI.promptStudios
                .testFromKb($stateParams.projectKey, $scope.savedModel.id, promptCreationSettings)
                .then(function ({ data }) {
                    $state.go('projects.project.promptstudios.promptstudio', { promptStudioId: data.promptStudioId, promptId: data.promptStudioPromptId });
                })
                .catch(setErrorInScope.bind($scope));
        });
    };
});

})();
