/* global describe, it, beforeEach, ChartFeaturesTestUtils */

describe('chart features binned_xy', function () {

    const chartType = 'binned_xy';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    describe('variant normal', function () {

        const chartVariant = 'normal';

        /* Initialize each test */
        beforeEach(() => {
            ChartFeaturesTestUtils.initEachTest();
            ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
            ChartFeaturesTestUtils.setAxisSpecs(chartType);
        });

        it('has left menu filters dropzone', function () {
            renderTemplate('/templates/simple_report/left-column/left-column.html');

            expectIdToBeVisible('qa_charts_filter-submenu-header');
            expectIdToBeVisible('qa_charts_filters-dropzone');
        })

        it('has left menu dimensions options', function () {
            renderTemplate('/templates/simple_report/left-column/dimensions.html');

            expectIdToBeVisible('qa_charts_tooltip-submenu-header');
            expectIdToBeVisible('qa_charts_animation-submenu-header');
            expectIdToBeVisible('qa_charts_animation-dropzone');
            expectIdToBeVisible('qa_charts_subchart-submenu-header');
            expectIdToBeVisible('qa_charts_subcharts-dropzone');
        })

        it('has axis options', function () {
            ChartFeaturesTestUtils.setXYDimensionFromNumericalColumns();
            renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);

            $('.measure-wrapper')[0].click(); // in X
            expectIdToBeVisible('qa_charts_one-tick-per-bin-select');
            expectIdToBeHidden('qa_charts_handling-empty-bins-select');
    
            $('.measure-wrapper')[1].click() // in Y
            expectIdToBeVisible('qa_charts_one-tick-per-bin-select');
            expectIdToBeHidden('qa_charts_handling-empty-bins-select');
        })

        it('doesn\'t have along dimension option', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
        })

        it('doesn\'t have regression line options', function () {
            renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
            expectIdToBeHidden('qa_charts_regression-line-form');
        })
    });

    describe('variant binned_xy_rect', function () {

        const chartVariant = 'binned_xy_rect';

        /* Initialize each test */
        beforeEach(() => {
            ChartFeaturesTestUtils.initEachTest();
            ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
            ChartFeaturesTestUtils.setAxisSpecs(chartType);
        });

        it('has left menu filters dropzone', function () {
            renderTemplate('/templates/simple_report/left-column/left-column.html');

            expectIdToBeVisible('qa_charts_filter-submenu-header');
            expectIdToBeVisible('qa_charts_filters-dropzone');
        })

        it('has left menu dimensions options', function () {
            renderTemplate('/templates/simple_report/left-column/dimensions.html');

            expectIdToBeVisible('qa_charts_tooltip-submenu-header');
            expectIdToBeVisible('qa_charts_animation-submenu-header');
            expectIdToBeVisible('qa_charts_animation-dropzone');
            expectIdToBeVisible('qa_charts_subchart-submenu-header');
            expectIdToBeVisible('qa_charts_subcharts-dropzone');
        })


        it('has axis options', function () {
            ChartFeaturesTestUtils.setXYDimensionFromNumericalColumns();
            renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);

            $('.measure-wrapper')[0].click(); // in X
            expectIdToBeVisible('qa_charts_one-tick-per-bin-select');
            expectIdToBeHidden('qa_charts_handling-empty-bins-select');
    
            $('.measure-wrapper')[1].click() // in Y
            expectIdToBeVisible('qa_charts_one-tick-per-bin-select');
            expectIdToBeHidden('qa_charts_handling-empty-bins-select');
        })

        it('doesn\'t have along dimension option', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
        })

        it('doesn\'t have regression line options', function () {
            renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
            expectIdToBeHidden('qa_charts_regression-line-form');
        })
    });

    describe('variant binned_xy_hex', function () {

        const chartVariant = 'binned_xy_hex';

        /* Initialize each test */
        beforeEach(() => {
            ChartFeaturesTestUtils.initEachTest();
            ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
            ChartFeaturesTestUtils.setAxisSpecs(chartType);
        });

        it('has left menu filters dropzone', function () {
            renderTemplate('/templates/simple_report/left-column/left-column.html');

            expectIdToBeVisible('qa_charts_filter-submenu-header');
            expectIdToBeVisible('qa_charts_filters-dropzone');
        })

        it('has left menu dimensions options', function () {
            renderTemplate('/templates/simple_report/left-column/dimensions.html');

            expectIdToBeVisible('qa_charts_tooltip-submenu-header');
            expectIdToBeVisible('qa_charts_animation-submenu-header');
            expectIdToBeVisible('qa_charts_animation-dropzone');
            expectIdToBeVisible('qa_charts_subchart-submenu-header');
            expectIdToBeVisible('qa_charts_subcharts-dropzone');
        })


        it('has axis options', function () {
            ChartFeaturesTestUtils.setXYDimensionFromNumericalColumns();
            renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);

            $('.measure-wrapper')[0].click(); // in X
            expectIdToBeHidden('qa_charts_one-tick-per-bin-select');
            expectIdToBeHidden('qa_charts_handling-empty-bins-select');
    
            $('.measure-wrapper')[1].click() // in Y
            expectIdToBeHidden('qa_charts_one-tick-per-bin-select');
            expectIdToBeHidden('qa_charts_handling-empty-bins-select');
        })

        it('doesn\'t have along dimension option', function () {
            ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
        })

        it('doesn\'t have regression line options', function () {
            renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
            expectIdToBeHidden('qa_charts_regression-line-form');
        })
    });
});
