def read_training_metrics(log_history):
    """ Returns training metrics formatted for Dataiku from a transformers.TrainerState event log

    :param List[Dict[str, Any]] log_history: the event log generated by a training session

    :returns Tuple[Dict[str, Any], int, int: metrics dict, number of epochs, total steps count
    """
    total_steps = 0
    nb_epochs = 0

    metrics = {}
    for event in log_history:
        current_step = str(event["step"])
        if current_step not in metrics:
            metrics[current_step] = {
                "step": current_step
            }

        # Training metric
        if "loss" in event:
            metrics[current_step]["trainingMetric"] = {
                "type": "TRAINING",
                "loss": event["loss"]
            }

        # Validation metric
        eval_loss = event.get("eval_loss", event.get("eval_train_loss"))
        if eval_loss:
            metrics[current_step]["validationMetric"] = {
                "type": "VALIDATION",
                "loss": eval_loss,
            }

        total_steps = max(event["step"], total_steps)
        nb_epochs = max(event["epoch"], nb_epochs)

    return {"metrics": metrics}, int(nb_epochs), int(total_steps)
