#! /bin/bash

# Pushing to Google Container Registry requires gcloud client to be configured as a docker credentials helper for the target docker host
# Use this script as pre-push script to automatically perform this operations before pushing to GCR

DOCKER_REGISTRY=$1
PROXY_SETTINGS_JSON=$2

proxy_username=$(echo $PROXY_SETTINGS_JSON | jq -r '.username // ""')
proxy_password=$(echo $PROXY_SETTINGS_JSON | jq -r '.password // ""')
proxy_host=$(echo $PROXY_SETTINGS_JSON | jq -r '.host // ""')
proxy_port=$(echo $PROXY_SETTINGS_JSON | jq -r '.port // ""')

if [[ -z $(command -v gcloud) ]]; then
  echo "ERROR: required $(gcloud) binary is not in PATH" >&2
  exit 1
fi

GCLOUD_VERSION=$(gcloud version 2>&1)
echo "gcloud cli version = $GCLOUD_VERSION"

if [[ -n "$proxy_host" && -n "$proxy_port" ]]; then
  echo "INFO: setup proxy address $proxy_host:$proxy_port in gcloud config"
  gcloud config set proxy/type http
  gcloud config set proxy/address $proxy_host
  gcloud config set proxy/port $proxy_port
  if [[ -n "$proxy_username" ]]; then
    echo "INFO: setup proxy authentication in gcloud config"
    gcloud config set proxy/username $proxy_username
    gcloud config set proxy/password $proxy_password
  fi
else
  echo "INFO: removing proxy settings from gcloud config"
  gcloud config unset proxy/type
  gcloud config unset proxy/address
  gcloud config unset proxy/port
fi

DOCKER_HOST=${DOCKER_REGISTRY%/*}
echo "INFO: setup docker credential helper for host $DOCKER_HOST"
yes | gcloud auth configure-docker $DOCKER_HOST

if (($?)); then
  echo 'ERROR: could not configure docker credential helper for gcr' >&2
fi
