# encoding: utf-8
"""
Executor for containerized execution of python doctor server that handles:
 * training
 * post-train computation (subpopulation/pdp)
"""

import json
import logging

from dataiku.doctor.server import serve
from .runner import setup_log, read_execution


if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_id = execution['id']
    definition = json.loads(execution['definition'])
    logging.info("Launching doctor command server")
    serve(definition['port'], definition['secret'], server_cert=definition.get('server_cert', 'NA'))
