/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ServiceConfigUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.PriorityLoadBalancer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Internal
public final class PriorityLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "priority_experimental";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new PriorityLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription(this.getPolicyName() + " cannot be used from service config"));
    }

    static final class PriorityLbConfig {
        final Map<String, PriorityChildConfig> childConfigs;
        final List<String> priorities;

        PriorityLbConfig(Map<String, PriorityChildConfig> childConfigs, List<String> priorities) {
            this.childConfigs = Collections.unmodifiableMap(Preconditions.checkNotNull(childConfigs, "childConfigs"));
            this.priorities = Collections.unmodifiableList(Preconditions.checkNotNull(priorities, "priorities"));
            Preconditions.checkArgument(!priorities.isEmpty(), "priority list is empty");
            Preconditions.checkArgument(childConfigs.keySet().containsAll(priorities), "missing child config for at lease one of the priorities");
            Preconditions.checkArgument(priorities.size() == new HashSet<String>(priorities).size(), "duplicate names in priorities");
            Preconditions.checkArgument(priorities.size() == childConfigs.keySet().size(), "some names in childConfigs are not referenced by priorities");
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("childConfigs", this.childConfigs).add("priorities", this.priorities).toString();
        }

        static final class PriorityChildConfig {
            final ServiceConfigUtil.PolicySelection policySelection;
            final boolean ignoreReresolution;

            PriorityChildConfig(ServiceConfigUtil.PolicySelection policySelection, boolean ignoreReresolution) {
                this.policySelection = Preconditions.checkNotNull(policySelection, "policySelection");
                this.ignoreReresolution = ignoreReresolution;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("policySelection", this.policySelection).add("ignoreReresolution", this.ignoreReresolution).toString();
            }
        }
    }
}

