/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.Mac;
import com.google.crypto.tink.prf.Prf;
import com.google.crypto.tink.subtle.Bytes;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;

@Immutable
public class PrfMac
implements Mac {
    static final int MIN_TAG_SIZE_IN_BYTES = 10;
    private final Prf wrappedPrf;
    private final int tagSize;

    public PrfMac(Prf wrappedPrf, int tagSize) throws GeneralSecurityException {
        this.wrappedPrf = wrappedPrf;
        this.tagSize = tagSize;
        if (tagSize < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, need at least 10 bytes");
        }
        byte[] unused = wrappedPrf.compute(new byte[0], tagSize);
    }

    @Override
    public byte[] computeMac(byte[] data) throws GeneralSecurityException {
        return this.wrappedPrf.compute(data, this.tagSize);
    }

    @Override
    public void verifyMac(byte[] mac, byte[] data) throws GeneralSecurityException {
        if (!Bytes.equal(this.computeMac(data), mac)) {
            throw new GeneralSecurityException("invalid MAC");
        }
    }
}

