/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.util;

import com.dataiku.dss.shadelibpoi.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import com.dataiku.dss.shadelibpoi.org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.Logger;
import com.dataiku.dss.shadelibpoi.org.apache.poi.logging.PoiLogManager;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.util.ZipInputStreamZipEntrySource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.temp.EncryptedTempData;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.IOUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.TempFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class ZipArchiveFakeEntry
extends ZipArchiveEntry
implements Closeable {
    private static final Logger LOG = PoiLogManager.getLogger(ZipArchiveFakeEntry.class);
    private static final int DEFAULT_MAX_ENTRY_SIZE = 100000000;
    private static int MAX_ENTRY_SIZE = 100000000;
    private byte[] data;
    private File tempFile;
    private EncryptedTempData encryptedTempData;

    public static void setMaxEntrySize(int maxEntrySize) {
        MAX_ENTRY_SIZE = maxEntrySize < 0 ? 100000000 : maxEntrySize;
    }

    public static int getMaxEntrySize() {
        int ioMaxSize = IOUtils.getByteArrayMaxOverride();
        return ioMaxSize < 0 ? MAX_ENTRY_SIZE : Math.min(MAX_ENTRY_SIZE, ioMaxSize);
    }

    ZipArchiveFakeEntry(ZipArchiveEntry entry, InputStream inp) throws IOException {
        super(entry.getName());
        long entrySize = entry.getSize();
        int threshold = ZipInputStreamZipEntrySource.getThresholdBytesForTempFiles();
        if (threshold >= 0 && (entrySize >= (long)threshold || entrySize == -1L)) {
            if (ZipInputStreamZipEntrySource.shouldEncryptTempFiles()) {
                this.encryptedTempData = new EncryptedTempData();
                try (OutputStream os = this.encryptedTempData.getOutputStream();){
                    IOUtils.copy(inp, os);
                }
            } else {
                this.tempFile = TempFile.createTempFile("poi-zip-entry", ".tmp");
                LOG.atInfo().log("Creating temp file {} for zip entry {} of size {} bytes", (Object)this.tempFile.getAbsolutePath(), (Object)entry.getName(), (Object)entrySize);
                IOUtils.copy(inp, this.tempFile);
            }
        } else {
            if (entrySize < -1L || entrySize >= Integer.MAX_VALUE) {
                throw new IOException("ZIP entry size is too large or invalid");
            }
            this.data = entrySize == -1L ? IOUtils.toByteArrayWithMaxLength(inp, ZipArchiveFakeEntry.getMaxEntrySize()) : IOUtils.toByteArray(inp, entrySize, ZipArchiveFakeEntry.getMaxEntrySize());
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.encryptedTempData != null) {
            try {
                return this.encryptedTempData.getInputStream();
            }
            catch (IOException e) {
                throw new IOException("failed to read from encrypted temp data", e);
            }
        }
        if (this.tempFile != null) {
            try {
                return Files.newInputStream(this.tempFile.toPath(), new OpenOption[0]);
            }
            catch (FileNotFoundException e) {
                throw new IOException("temp file " + this.tempFile.getAbsolutePath() + " is missing");
            }
        }
        if (this.data != null) {
            return UnsynchronizedByteArrayInputStream.builder().setByteArray(this.data).get();
        }
        throw new IOException("Cannot retrieve data from Zip Entry, probably because the Zip Entry was closed before the data was requested.");
    }

    @Override
    public void close() throws IOException {
        this.data = null;
        if (this.encryptedTempData != null) {
            this.encryptedTempData.dispose();
        }
        if (this.tempFile != null && this.tempFile.exists() && !this.tempFile.delete()) {
            LOG.atDebug().log("temp file was already deleted (probably due to previous call to close this resource)");
        }
    }
}

