/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateIpamScopeRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateIpamScopeRequestMarshaller
implements Marshaller<Request<CreateIpamScopeRequest>, CreateIpamScopeRequest> {
    @Override
    public Request<CreateIpamScopeRequest> marshall(CreateIpamScopeRequest createIpamScopeRequest) {
        SdkInternalList createIpamScopeRequestTagSpecificationsList;
        if (createIpamScopeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateIpamScopeRequest> request = new DefaultRequest<CreateIpamScopeRequest>(createIpamScopeRequest, "AmazonEC2");
        request.addParameter("Action", "CreateIpamScope");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createIpamScopeRequest.getIpamId() != null) {
            request.addParameter("IpamId", StringUtils.fromString(createIpamScopeRequest.getIpamId()));
        }
        if (createIpamScopeRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createIpamScopeRequest.getDescription()));
        }
        if (!(createIpamScopeRequestTagSpecificationsList = (SdkInternalList)createIpamScopeRequest.getTagSpecifications()).isEmpty() || !createIpamScopeRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createIpamScopeRequestTagSpecificationsListValue : createIpamScopeRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createIpamScopeRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createIpamScopeRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createIpamScopeRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createIpamScopeRequest.getClientToken()));
        return request;
    }
}

