/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateRouteRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateRouteRequestMarshaller
implements Marshaller<Request<CreateRouteRequest>, CreateRouteRequest> {
    @Override
    public Request<CreateRouteRequest> marshall(CreateRouteRequest createRouteRequest) {
        if (createRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateRouteRequest> request = new DefaultRequest<CreateRouteRequest>(createRouteRequest, "AmazonEC2");
        request.addParameter("Action", "CreateRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(createRouteRequest.getDestinationCidrBlock()));
        }
        if (createRouteRequest.getDestinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString(createRouteRequest.getDestinationIpv6CidrBlock()));
        }
        if (createRouteRequest.getDestinationPrefixListId() != null) {
            request.addParameter("DestinationPrefixListId", StringUtils.fromString(createRouteRequest.getDestinationPrefixListId()));
        }
        if (createRouteRequest.getVpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString(createRouteRequest.getVpcEndpointId()));
        }
        if (createRouteRequest.getEgressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringUtils.fromString(createRouteRequest.getEgressOnlyInternetGatewayId()));
        }
        if (createRouteRequest.getGatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString(createRouteRequest.getGatewayId()));
        }
        if (createRouteRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createRouteRequest.getInstanceId()));
        }
        if (createRouteRequest.getNatGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString(createRouteRequest.getNatGatewayId()));
        }
        if (createRouteRequest.getTransitGatewayId() != null) {
            request.addParameter("TransitGatewayId", StringUtils.fromString(createRouteRequest.getTransitGatewayId()));
        }
        if (createRouteRequest.getLocalGatewayId() != null) {
            request.addParameter("LocalGatewayId", StringUtils.fromString(createRouteRequest.getLocalGatewayId()));
        }
        if (createRouteRequest.getCarrierGatewayId() != null) {
            request.addParameter("CarrierGatewayId", StringUtils.fromString(createRouteRequest.getCarrierGatewayId()));
        }
        if (createRouteRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(createRouteRequest.getNetworkInterfaceId()));
        }
        if (createRouteRequest.getRouteTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString(createRouteRequest.getRouteTableId()));
        }
        if (createRouteRequest.getVpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString(createRouteRequest.getVpcPeeringConnectionId()));
        }
        if (createRouteRequest.getCoreNetworkArn() != null) {
            request.addParameter("CoreNetworkArn", StringUtils.fromString(createRouteRequest.getCoreNetworkArn()));
        }
        return request;
    }
}

