/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.sanitycheck.SanityCheckService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPISanityCheckController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SanityCheckService sanityCheckService;

    @AuditedCall(value={"msgType", "admin-sanity-check-run"})
    @RequestMapping(value={"/publicapi/admin/sanity-check/run"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> run(HttpServletRequest req, @RequestBody Set<String> exclusionList) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.sanityCheckService.run(authCtx, exclusionList);
    }

    @AuditedCall(value={"msgType", "admin-sanity-check-get-codes"})
    @RequestMapping(value={"/publicapi/admin/sanity-check/codes"})
    @ResponseBody
    public List<InfoMessage.MessageCode> getCodes(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.sanityCheckService.getCodes();
    }
}

