/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.datasets;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.UsabilityComputer;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.datasets.SQLCommentService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/datasets"})
public class PublicAPIDatasetsCRUDController
extends PublicAPIControllerBase {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetDeletionService deletionService;
    @Autowired
    private DatasetSaveService saveService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ManagedDatasetsCreationService mdcService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private SQLCommentService sqlCommentService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.datasets");

    @AuditedCall(value={"msgType", "datasets-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<SerializedDataset> list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="false") boolean foreign, @RequestParam(required=false) String[] tags) throws Exception {
        ArrayList<SerializedDataset> datasets;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            if (!foreign) {
                datasets = this.datasetsDAO.listUnsafe(projectKey);
            } else {
                UsabilityComputer.ListSettings settings = new UsabilityComputer.ListSettings();
                settings.datasetsOnly = true;
                ProjectFlowGraph graph = this.graphService.getProjectGraphUnsafe(projectKey);
                UsabilityComputer uc = new UsabilityComputer(null, (FlowGraph)graph, settings, true, projectKey);
                List computables = uc.computeUnsafe(null);
                datasets = new ArrayList();
                for (UsabilityComputer.UsableComputable comp : computables) {
                    datasets.add(comp.dataset);
                }
            }
        }
        if (tags != null && tags.length > 0) {
            ArrayList<SerializedDataset> unfilteredDatasets = datasets;
            datasets = new ArrayList<SerializedDataset>();
            block6: for (SerializedDataset ds : unfilteredDatasets) {
                for (String tag : tags) {
                    if (!ds.tags.contains(tag)) continue;
                    datasets.add(ds);
                    continue block6;
                }
            }
        }
        return datasets;
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void add(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String fullName;
        SerializedDataset sds;
        block20: {
            AuthCtx authCtx;
            sds = (SerializedDataset)this.getRequestBodyAs(req, SerializedDataset.class);
            this.require(StringUtils.isNotBlank((String)sds.projectKey), "Required field 'projectKey' is missing.");
            this.require(StringUtils.isNotBlank((String)sds.name), "Required field 'name' is missing.");
            this.require(StringUtils.isNotBlank((String)sds.type), "Required field 'type' is missing.");
            DatasetUtils.checkName((String)sds.name);
            fullName = sds.projectKey + "." + sds.name;
            if (sds.getSchema() == null) {
                sds.setSchema(new Schema());
            }
            try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
                authCtx = t.getUser();
                this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildDefault();
                this.saveService.create(sds.projectKey, sds, dsCtx, t.getUser());
                t.commit("Created dataset " + fullName);
            }
            try (DatasetHandler dh = DatasetHandlerFactory.build((AuthCtx)authCtx, (Dataset)Dataset.fromSerialized((SerializedDataset)sds));){
                if (!dh.executeSlowPostCreateOperations_NT()) break block20;
                try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
                    sds = dh.getDataset().serialize();
                    this.saveService.saveWithoutEvents(projectKey, dh.getDataset().getName(), sds, t.getUser());
                    t.commit("Created dataset " + dh.getDataset().getFullName() + " (post-creation auto-commit)");
                }
            }
        }
        this.auditTrailService.generic("dataset-create").with("projectKey", projectKey).with("datasetName", sds.name).with("type", sds.type).emit();
        this.writeMessage(resp, "Create dataset %s", new Object[]{fullName});
    }

    @AuditedCall(value={"msgType", "dataset-get", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        SerializedDataset sds;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_METADATA});
            sds = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        PublicAPIDatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)sds);
    }

    @AuditedCall(value={"msgType", "dataset-save", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName:.+}"}, method={RequestMethod.PUT})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        SerializedDataset oldSds;
        AuthCtx authCtx;
        SerializedDataset sds;
        JsonObject body;
        try {
            body = (JsonObject)JSON.parse((InputStream)req.getInputStream(), JsonObject.class);
            sds = (SerializedDataset)JSON.parse((JsonElement)body, SerializedDataset.class);
        }
        catch (Exception e) {
            throw new DKUControllerBase.MalformedRequestException(String.format("Could not parse a %s from request body", SerializedDataset.class.getSimpleName()), (Throwable)e);
        }
        this.require(StringUtils.isNotBlank((String)sds.projectKey), "Required field 'projectKey' is missing.");
        this.require(StringUtils.isNotBlank((String)sds.name), "Required field 'name' is missing.");
        this.require(StringUtils.isNotBlank((String)sds.type), "Required field 'type' is missing.");
        this.require(sds.projectKey.equals(projectKey), "Dataset projectKey does not match the requested URL");
        String fullName = sds.projectKey + "." + sds.name;
        this.enrichSerializedDatasetWithLegacyParams(sds, body);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            authCtx = t.getUser();
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.WRITE_METADATA});
            oldSds = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(sds.projectKey, sds.name);
            this.saveService.save(sds.projectKey, sds.name, sds, authCtx);
            t.commit("Updated dataset " + fullName);
        }
        if (!Objects.equals(sds.description, oldSds.description)) {
            this.sqlCommentService.addCommentToTable(sds, sds.description, authCtx);
        }
        this.writeMessage(resp, "Updated dataset %s", new Object[]{fullName});
    }

    private void enrichSerializedDatasetWithLegacyParams(SerializedDataset sd, JsonObject body) {
        LegacyChecksDataset legacyDataset;
        try {
            legacyDataset = (LegacyChecksDataset)JSON.parse((JsonElement)body, LegacyChecksDataset.class);
        }
        catch (JsonSyntaxException ignored) {
            legacyDataset = null;
        }
        if (legacyDataset != null && legacyDataset.metricsChecks != null && legacyDataset.metricsChecks.runOnBuild != null) {
            LegacyChecksDataset finalLegacyDataset = legacyDataset;
            sd.getDataQualityRuleSet().getRules().forEach(r -> {
                r.autoRun = finalLegacyDataset.metricsChecks.runOnBuild;
            });
        }
    }

    @AuditedCall(value={"msgType", "dataset-delete", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName:.+}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(required=false, defaultValue="false") boolean dropData) throws Exception {
        String fullName;
        Dataset ds;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            ds = this.datasetAccessService.getMandatory(projectKey, datasetName);
            fullName = ds.getFullName();
        }
        TaggableObjectsDeletionService.DeletionOptions opts = new TaggableObjectsDeletionService.DeletionOptions();
        opts.dropData = dropData;
        opts.dropMetastoreTable = dropData;
        this.deletionService.clearDatasetForDeletion_NT(authCtx, ds, opts);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.deletionService.performDeletion(ds, null, authCtx, false);
            this.saveService.delete(projectKey, datasetName);
            this.flowGraphService.invalidateCache(projectKey);
            t.commit("Deleted dataset " + fullName);
        }
        this.writeMessage(resp, "Deleted dataset %s", new Object[]{fullName});
    }

    @AuditInline
    @RequestMapping(value={"/managed"}, method={RequestMethod.POST})
    public void createManaged(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ProtoManagedDataset pmd = (ProtoManagedDataset)this.getRequestBodyAs(req, ProtoManagedDataset.class);
        this.checkNotNull(pmd.name, "Name not given", new Object[0]);
        this.checkNotNull(pmd.creationSettings, "Creation settings not given", new Object[0]);
        if (!pmd.creationSettings.inlineDataset) {
            this.checkNotNull(pmd.creationSettings.connectionId, "Connection not given", new Object[0]);
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SerializedDataset sd = this.mdcService.create(t.getUser(), projectKey, pmd.name, pmd.creationSettings);
            t.commit("Created managed dataset: " + projectKey + "." + pmd.name);
            PublicAPIDatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)sd);
            this.auditTrailService.generic("dataset-create").with("projectKey", projectKey).with("datasetName", pmd.name).with("connection", pmd.creationSettings.connectionId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("dataset-create", (Throwable)e).with("projectKey", projectKey).with("datasetName", pmd.name).with("connection", pmd.creationSettings.connectionId).emit();
            throw e;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/templates"}, method={RequestMethod.GET})
    public void getTemplate(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        DatasetTemplates ret = new DatasetTemplates();
        ret.dataset = new SerializedDataset();
        ret.dataset.partitioning = new PartitioningScheme();
        ret.dataset.setAllFieldsToNonRawMode();
        ret.abstractFSConfig = new AbstractFSDatasetHandler.AbstractFSConfig();
        ret.abstractSQLConfig = new AbstractSQLDatasetHandler.AbstractSQLConfig();
        ret.csvFormat = CSVFormatConfig.getStandardTabExcelFormat();
        ret.parquetFormat = new ParquetFormatConfig();
        ret.orcFormat = new ORCFileFormatConfig();
        PublicAPIDatasetsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    private static class LegacyChecksDataset {
        LegacyMetricsChecksParams metricsChecks;

        private LegacyChecksDataset() {
        }

        static class LegacyMetricsChecksParams {
            Boolean runOnBuild;

            LegacyMetricsChecksParams() {
            }
        }
    }

    public static class ProtoManagedDataset {
        public String name;
        public ManagedDatasetsCreationService.ManagedDatasetCreationSettings creationSettings;
    }

    public static class DatasetTemplates {
        public SerializedDataset dataset;
        public AbstractSQLDatasetHandler.AbstractSQLConfig abstractSQLConfig;
        public AbstractFSDatasetHandler.AbstractFSConfig abstractFSConfig;
        public CSVFormatConfig csvFormat;
        public ParquetFormatConfig parquetFormat;
        public ORCFileFormatConfig orcFormat;
    }
}

