/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.datasets;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/datasets/{datasetName}"})
public class PublicAPIDatasetsDataLineageController
extends PublicAPIControllerBase {
    @Autowired
    private DataLineageService dataLineageService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;

    @AuditedCall(value={"msgType", "data-lineage-get-column-lineage", "projectKey", "${projectKey}", "datasetName", "{datasetName}", "columnName", "${columnName}", "maxDatasetCount", "${maxDatasetCount}"})
    @RequestMapping(value={"/column-lineage"}, method={RequestMethod.GET})
    public void getColumnLineage(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam String columnName, @RequestParam(required=false) Integer maxDatasetCount) throws Exception {
        AuthCtx authCtx;
        if (maxDatasetCount != null && maxDatasetCount <= 0) {
            throw new IllegalArgumentException("Invalid value, maxDatasetCount must be a positive integer.");
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        Set columnRelations = this.dataLineageService.getGraphNodes_NT((AuthCtx)authCtx, (String)projectKey, (String)projectKey, (String)datasetName, (String)columnName, (Integer)maxDatasetCount).columnRelations;
        PublicAPIDatasetsDataLineageController.writeJSON((HttpServletResponse)resp, (Object)columnRelations);
    }
}

