/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.expr;

import com.dataiku.dip.shaker.processors.expr.WordType;
import com.dataiku.dip.shaker.text.StringNormalizer;
import com.dataiku.dss.shadelib.org.tartarus.snowball.SnowballStemmer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

public class TokenizedText
implements Iterable<WordType> {
    List<WordType> listTokens;

    public int size() {
        return this.listTokens.size();
    }

    public void add(WordType t) {
        this.listTokens.add(t);
    }

    public WordType get(int i) {
        return this.listTokens.get(i);
    }

    public TokenizedText getTokens(int fromIndex, int toIndex) {
        return new TokenizedText(this.listTokens.subList(fromIndex, toIndex));
    }

    public TokenizedText() {
        this.listTokens = new ArrayList<WordType>();
    }

    public TokenizedText(TokenizedText tt) {
        this.listTokens = new ArrayList<WordType>(tt.listTokens);
    }

    private TokenizedText(List<WordType> l) {
        this.listTokens = new ArrayList<WordType>(l);
    }

    public TokenizedText(String s) {
        this.listTokens = new ArrayList<WordType>();
        WordType.tokenize(s, this.listTokens);
    }

    public void alphaSort() {
        Collections.sort(this.listTokens);
    }

    public void normalize() {
        for (WordType t : this.listTokens) {
            t.stringRep = StringNormalizer.normalize(t.stringRep).toUpperCase().toLowerCase();
        }
    }

    public JSONArray toJSONArray() {
        ArrayList<String> l = new ArrayList<String>(this.listTokens.size());
        for (WordType t : this.listTokens) {
            l.add(t.toString());
        }
        return new JSONArray(l);
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String separator) {
        if (this.listTokens.size() == 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        for (WordType t : this.listTokens) {
            res.append(t.toString());
            res.append(separator);
        }
        return res.substring(0, res.length() - 1);
    }

    public void clearStopWords(Set<String> stopWords) {
        this.listTokens.removeIf(o -> stopWords.contains(o.toString().toLowerCase()));
    }

    public void stem(SnowballStemmer stemmer) {
        for (WordType t : this.listTokens) {
            stemmer.setCurrent(t.stringRep);
            stemmer.stem();
            t.stringRep = stemmer.getCurrent();
        }
    }

    @Override
    public Iterator<WordType> iterator() {
        return this.listTokens.iterator();
    }
}

