/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;

public class SingleCommandKernelLink
extends SecretProtectedKernelLink {
    public SingleCommandKernelLink(String secret, PortRangeParams portRange, SSLContext sslContext) throws IOException {
        super(secret, portRange, sslContext);
    }

    public SingleCommandKernelLink(String secret, PortRangeParams portRange) throws IOException {
        super(secret, portRange);
    }

    public SingleCommandKernelLink(String secret) throws IOException {
        super(secret);
    }

    public <TResp> TResp execute(Object req, Class<? extends TResp> clazz, String exceptionIfNullMessage) throws IOException {
        return this.executeAsync(req, null, false, clazz, null, false, null, exceptionIfNullMessage).call();
    }

    public void executeStream(Object req, OutputStream os) throws IOException {
        this.executeAsync(req, null, false, null, null, false, os, null).call();
    }

    public <TResp> TResp execute(Object req, InputStream is, Class<? extends TResp> clazz, String exceptionIfNullMessage) throws IOException {
        return this.executeAsync(req, is, false, clazz, null, false, null, exceptionIfNullMessage).call();
    }

    public void executeStream(Object req, InputStream is, OutputStream os) throws IOException {
        this.executeAsync(req, is, false, null, null, false, os, null).call();
    }

    public IOCallable<Void> executeStreamAsync(Object req, OutputStream os) throws IOException {
        return this.executeAsync(req, null, false, null, null, false, os, null);
    }

    public <TResp> IOCallable<TResp> executeAsync(Object req, InputStream is, Class<? extends TResp> clazz, String exceptionIfNullMessage) throws IOException {
        return this.executeAsync(req, is, false, clazz, null, false, null, exceptionIfNullMessage);
    }

    public <TResp> IOCallable<TResp> executeWithAsyncStreamAsync(Object req, Class<? extends TResp> clazz) throws IOException {
        return this.executeAsync(req, null, true, clazz, null, false, null, null);
    }

    public IOCallable<Void> executeVoidAsync(Object req, InputStream is) throws IOException {
        return this.executeAsync(req, is, false, null, null, false, null, null);
    }

    public IOCallable<Void> executeStreamAsync(Object req, InputStream is, OutputStream os) throws IOException {
        return this.executeAsync(req, is, false, null, null, false, os, null);
    }

    private <TResp> IOCallable<TResp> executeAsync(Object req, InputStream is, boolean inputAsync, Class<? extends TResp> clazz, TypeToken<? extends TResp> typeToken, boolean isString, OutputStream os, String exceptionIfNullMessage) throws IOException {
        SocketBlockLinkInteraction interaction = this.newInteraction();
        if (StringUtils.isNotBlank((String)exceptionIfNullMessage)) {
            interaction.withExceptionIfNullMessage(exceptionIfNullMessage);
        }
        if (req != null) {
            interaction.withRequest(req);
        }
        if (is != null) {
            interaction.withStream(is);
        }
        if (inputAsync) {
            interaction.withAsyncStream();
        }
        if (clazz != null) {
            interaction.expectsObject(clazz);
        } else if (typeToken != null) {
            interaction.expectsObject(typeToken);
        } else if (isString) {
            interaction.expectsString();
        } else if (os != null) {
            interaction.expectsStream(os);
        }
        final SocketBlockLinkInteraction.AsyncResult execution = interaction.executeAsync();
        return new IOCallable<TResp>(){

            @Override
            public TResp call() throws IOException {
                return execution.get();
            }
        };
    }

    public static interface IOCallable<T>
    extends Callable<T> {
        @Override
        public T call() throws IOException;
    }
}

