/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.dataiku.dip.transactions.fs.FileContentCompressor;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.StreamSupplier;
import com.dataiku.dip.utils.CrudeJSONifiableObjectSizeEstimator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CountingInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public final class FileContent {
    public static final long SMALL_FILE_THRESHOLD_IN_BYTES = 0x100000L;
    @VisibleForTesting
    Object object;
    @VisibleForTesting
    byte[] compressedBytes;
    @VisibleForTesting
    StreamSupplier uncompressedStreamSupplier;
    long uncompressedLength = -1L;
    FileContentCompressor compressor;
    private byte[] hash;

    FileContent() {
    }

    public ReadOnlyFS.CompressedFileData getCompressedFileData() throws IOException {
        return new ReadOnlyFS.CompressedFileData(this.getAsCompressedBytes(), this.compressor, this.getUncompressedLength());
    }

    public synchronized long getUncompressedLength() {
        if (this.uncompressedLength == -1L) {
            try {
                this.getAsCompressedBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not compute length", e);
            }
        }
        assert (this.uncompressedLength >= 0L);
        return this.uncompressedLength;
    }

    public synchronized long getInMemoryLength() {
        if (!this.isPossiblyNotStoredInMemory()) {
            return this.getUncompressedLength();
        }
        return 0L;
    }

    public synchronized byte[] getHash() throws IOException {
        if (this.hash != null) {
            return this.hash;
        }
        MessageDigest digest = DigestUtils.getSha1Digest();
        try (InputStream stream = this.getAsNewStream();){
            DigestUtils.updateDigest((MessageDigest)digest, (InputStream)stream);
            this.hash = digest.digest();
        }
        return this.hash;
    }

    public synchronized <T> T getAsNewObject(Class<T> clazz) throws IOException {
        FileContentCompressor compressor = this.compressor;
        if (this.compressedBytes != null) {
            try (InputStream uncompressedStream = compressor.uncompressStream(new ByteArrayInputStream(this.compressedBytes));){
                Object object = JSON.parse((InputStream)uncompressedStream, clazz);
                return (T)object;
            }
        }
        if (this.uncompressedStreamSupplier != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(this.getAsCompressedBytes());){
                Object object;
                block20: {
                    InputStream uncompressedBais = compressor.uncompressStream(bais);
                    try {
                        object = JSON.parse((InputStream)uncompressedBais, clazz);
                        if (uncompressedBais == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (uncompressedBais != null) {
                            try {
                                uncompressedBais.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    uncompressedBais.close();
                }
                return (T)object;
            }
        }
        if (this.object != null) {
            byte[] uncompressedBytes = JSON.prettyToBytesAsFile((Object)this.object);
            this.compressedBytes = compressor.compressBytes(uncompressedBytes);
            this.uncompressedLength = uncompressedBytes.length;
            return (T)JSON.parse((byte[])uncompressedBytes, clazz);
        }
        throw new RuntimeException("Unreachable");
    }

    public synchronized <T> T getAsObject(Class<T> clazz) throws IOException {
        FileContentCompressor compressor = this.compressor;
        if (clazz.isInstance(this.object)) {
            return (T)this.object;
        }
        if (this.compressedBytes != null) {
            try (InputStream uncompressedStream = compressor.uncompressStream(new ByteArrayInputStream(this.compressedBytes));){
                Object object = this.object = JSON.parse((InputStream)uncompressedStream, clazz);
                return (T)object;
            }
        }
        if (this.uncompressedStreamSupplier != null) {
            try (InputStream uncompressedStream = compressor.uncompressStream(new ByteArrayInputStream(this.getAsCompressedBytes()));){
                Object object = this.object = JSON.parse((InputStream)uncompressedStream, clazz);
                return (T)object;
            }
        }
        if (this.object != null && !clazz.isInstance(this.object)) {
            return (T)JSON.parse((byte[])JSON.prettyToBytesAsFile((Object)this.object), clazz);
        }
        throw new RuntimeException("Unreachable");
    }

    public synchronized String getAsString() throws IOException {
        byte[] compressedBytes = this.getAsCompressedBytes();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(compressedBytes);){
            String string;
            block11: {
                InputStream uncompressedBais = this.compressor.uncompressStream(bais);
                try {
                    string = IOUtils.toString((InputStream)uncompressedBais, (Charset)StandardCharsets.UTF_8);
                    if (uncompressedBais == null) break block11;
                }
                catch (Throwable throwable) {
                    if (uncompressedBais != null) {
                        try {
                            uncompressedBais.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                uncompressedBais.close();
            }
            return string;
        }
    }

    public synchronized InputStream getAsNewStream() throws IOException {
        if (this.compressedBytes != null) {
            return this.compressor.uncompressStream(new ByteArrayInputStream(this.compressedBytes));
        }
        if (this.uncompressedStreamSupplier != null) {
            if (this.uncompressedLength > 0x100000L) {
                return this.uncompressedStreamSupplier.openStream();
            }
            return this.compressor.uncompressStream(new ByteArrayInputStream(this.getAsCompressedBytes()));
        }
        if (this.object != null) {
            byte[] uncompressedBytes = JSON.prettyToBytesAsFile((Object)this.object);
            this.compressedBytes = this.compressor.compressBytes(uncompressedBytes);
            this.uncompressedLength = uncompressedBytes.length;
            return new ByteArrayInputStream(uncompressedBytes);
        }
        throw new RuntimeException("Unreachable");
    }

    public boolean isPossiblyNotStoredInMemory() {
        return this.uncompressedStreamSupplier != null;
    }

    public synchronized byte[] getAsCompressedBytes() throws IOException {
        if (this.compressedBytes != null) {
            return this.compressedBytes;
        }
        if (this.uncompressedStreamSupplier != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (InputStream is = this.uncompressedStreamSupplier.openStream();
                 CountingInputStream cis = new CountingInputStream(is);
                 OutputStream compressedOs = this.compressor.compressStream(baos);){
                IOUtils.copyLarge((InputStream)cis, (OutputStream)compressedOs);
                this.uncompressedLength = cis.getCount();
            }
            this.compressedBytes = baos.toByteArray();
            this.uncompressedStreamSupplier = null;
            return this.compressedBytes;
        }
        if (this.object != null) {
            byte[] uncompressedBytes = JSON.prettyToBytesAsFile((Object)this.object);
            this.uncompressedLength = uncompressedBytes.length;
            this.compressedBytes = this.compressor.compressBytes(uncompressedBytes);
            return this.compressedBytes;
        }
        throw new RuntimeException("Unreachable");
    }

    public byte[] getAsNewBytes() throws IOException {
        byte[] bytes = this.getAsCompressedBytes();
        return this.compressor.uncompressBytes(bytes, this.uncompressedLength);
    }

    @Nullable
    public synchronized StoredBytesStats getBytesStatsIfAvailable() {
        if (this.uncompressedLength == -1L || this.compressedBytes == null) {
            return null;
        }
        StoredBytesStats stats = new StoredBytesStats();
        stats.uncompressedLength = this.uncompressedLength;
        stats.compressedLength = this.compressedBytes.length;
        return stats;
    }

    public synchronized boolean hasObject() {
        return this.object != null;
    }

    public synchronized String inspectionData() {
        return String.format("hasStream=%s hasObject=%s hasCompressedBytes=%s objBytesJSON=%d compressedBytesBytes=%d uncompressedLength=%s compressor=%s detailedObject=[%s] hash=%s", this.uncompressedStreamSupplier != null ? "true" : "false", this.object != null, this.compressedBytes != null, this.object == null ? 0 : JSON.prettyAsFile((Object)this.object).length() * 2, this.compressedBytes == null ? 0 : this.compressedBytes.length, this.uncompressedLength, this.compressor.name(), this.object == null ? Integer.valueOf(0) : CrudeJSONifiableObjectSizeEstimator.estimateObjectSize(this.object), this.hash == null ? "null" : Hex.encodeHexString((byte[])this.hash));
    }

    public synchronized String fullDumpObject() {
        return this.object == null ? "null" : CrudeJSONifiableObjectSizeEstimator.dumpObjectStructure(this.object);
    }

    public static class StoredBytesStats {
        public long uncompressedLength;
        public long compressedLength;
    }
}

