/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.imfs;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.dataiku.dip.transactions.fs.ConcreteRelFileAttribute;
import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.Journal;
import com.dataiku.dip.transactions.fs.ReadOnlyFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.dataiku.dip.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class InMemoryCache
extends ReadOnlyFSBase
implements CachedReadFS {
    private final TreeMap<RelFile, Set<RelFile>> cachedListings = new TreeMap();
    private final TreeMap<RelFile, RelFileAttribute> cachedAttributes = new TreeMap();
    private final TreeSet<RelFile> cachedFilePresences = new TreeSet();
    private final Cache<RelFile, FileContent> cachedContents;
    private final RelFileFilter cacheabilityFilter;
    private ReadOnlyFS base;
    private final boolean negativeCachingEnabled;
    @Nullable
    private Metrics metrics;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.transactions.inmemorycache");

    public InMemoryCache(ReadOnlyFS base) {
        this(base, new AcceptAllFilter(), true);
    }

    public InMemoryCache(ReadOnlyFS base, RelFileFilter cacheabilityFilter, boolean negativeCachingEnabled) {
        Cache _cache;
        this.cacheabilityFilter = cacheabilityFilter;
        this.negativeCachingEnabled = negativeCachingEnabled;
        this.base = base;
        try {
            _cache = CacheBuilder.newBuilder().recordStats().build();
        }
        catch (NoSuchMethodError e) {
            logger.warn((Object)("Failed to create cache with stats recording, retrying without: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            _cache = CacheBuilder.newBuilder().build();
        }
        this.cachedContents = _cache;
    }

    @Override
    public synchronized void registerMetrics(String prefix, MetricRegistry registry) {
        if (this.metrics == null) {
            Metrics metrics = new Metrics();
            metrics.registerOn(prefix, registry);
            this.metrics = metrics;
        }
    }

    @VisibleForTesting
    synchronized void setBaseFS(ReadOnlyFS base) {
        this.base = base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RelFile> listFilesUnordered(RelFile directory) throws IOException {
        Set<RelFile> listing;
        if (!this.cacheabilityFilter.accept(this, directory)) {
            return this.base.listFilesUnordered(directory);
        }
        InMemoryCache inMemoryCache = this;
        synchronized (inMemoryCache) {
            listing = this.cachedListings.get(directory);
        }
        if (listing == null) {
            listing = new HashSet<RelFile>(this.base.listFilesUnordered(directory));
            inMemoryCache = this;
            synchronized (inMemoryCache) {
                this.cachedListings.put(directory, listing);
            }
        }
        return new ArrayList<RelFile>(listing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileContent readContentUnsafe(RelFile file) throws IOException {
        FileContent content;
        if (!this.cacheabilityFilter.accept(this, file)) {
            return this.base.readContentUnsafe(file);
        }
        InMemoryCache inMemoryCache = this;
        synchronized (inMemoryCache) {
            content = (FileContent)this.cachedContents.getIfPresent((Object)file);
        }
        if (content == null) {
            content = this.base.readContentUnsafe(file);
            inMemoryCache = this;
            synchronized (inMemoryCache) {
                this.cachedFilePresences.add(file);
                this.cachedContents.put((Object)file, (Object)content);
            }
        }
        return content;
    }

    @Nullable
    private static RelFile longestPrefixChild(Set<RelFile> files, RelFile key) {
        if (key.isRoot()) {
            return null;
        }
        do {
            if (!files.contains(key.getParent())) continue;
            return key;
        } while (!(key = key.getParent()).isRoot());
        return null;
    }

    private RelFileAttribute getCachedAttributes(RelFile file) {
        RelFileAttribute attributes = this.cachedAttributes.get(file);
        if (attributes != null) {
            return attributes;
        }
        if (this.cachedListings.containsKey(file)) {
            return new ConcreteRelFileAttribute(file, RelFileAttribute.FileType.DIRECTORY, -1L, -1L);
        }
        RelFile potentialFileInsideDirectory = this.cachedFilePresences.ceiling(file);
        if (potentialFileInsideDirectory != null && potentialFileInsideDirectory.isStrictChildOf(file)) {
            return new ConcreteRelFileAttribute(file, RelFileAttribute.FileType.DIRECTORY, -1L, -1L);
        }
        return null;
    }

    @Override
    public RelFileAttribute getAttributes(RelFile file) throws IOException {
        return this.getAttributes(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelFileAttribute getAttributes(RelFile file, boolean skipCache) throws IOException {
        InMemoryCache inMemoryCache;
        if (!this.cacheabilityFilter.accept(this, file)) {
            return this.base.getAttributes(file);
        }
        RelFileAttribute attributes = null;
        if (!skipCache) {
            inMemoryCache = this;
            synchronized (inMemoryCache) {
                Pair<Boolean, RelFileAttribute> cached = this.getCachedExists(file);
                if (Boolean.FALSE.equals(cached.first)) {
                    return null;
                }
                attributes = (RelFileAttribute)cached.second;
            }
        }
        if (attributes == null) {
            attributes = this.base.getAttributes(file);
            if (attributes == null) {
                if (this.negativeCachingEnabled) {
                    if (!file.isRoot()) {
                        file = file.getParent();
                    }
                    while (!file.isRoot()) {
                        if (this.isDirectory(file)) {
                            this.listFilesUnordered(file);
                            break;
                        }
                        file = file.getParent();
                    }
                }
            } else {
                inMemoryCache = this;
                synchronized (inMemoryCache) {
                    this.cachedAttributes.put(file, attributes);
                }
            }
        }
        return attributes;
    }

    private Pair<Boolean, RelFileAttribute> getCachedExists(RelFile file) {
        RelFileAttribute attribute = this.getCachedAttributes(file);
        if (attribute != null) {
            return new Pair((Object)true, (Object)attribute);
        }
        if (!file.isRoot()) {
            RelFile longestPrefixChild = InMemoryCache.longestPrefixChild(this.cachedListings.keySet(), file);
            if (longestPrefixChild != null && !this.cachedListings.get(longestPrefixChild.getParent()).contains(longestPrefixChild)) {
                return new Pair((Object)false, null);
            }
            Set<RelFile> parentListing = this.cachedListings.get(file.getParent());
            if (parentListing != null) {
                return new Pair((Object)parentListing.contains(file), null);
            }
        }
        return new Pair(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(RelFile file) throws IOException {
        Pair<Boolean, RelFileAttribute> cachedExists;
        InMemoryCache inMemoryCache = this;
        synchronized (inMemoryCache) {
            cachedExists = this.getCachedExists(file);
        }
        if (cachedExists.first == null) {
            RelFileAttribute attributes = this.getAttributes(file, true);
            return attributes != null;
        }
        return (Boolean)cachedExists.first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFile(RelFile file) throws IOException {
        boolean isPresenceCached;
        InMemoryCache inMemoryCache = this;
        synchronized (inMemoryCache) {
            if (Boolean.FALSE.equals(this.getCachedExists((RelFile)file).first)) {
                return false;
            }
            isPresenceCached = this.cachedFilePresences.contains(file);
        }
        return isPresenceCached || super.isFile(file);
    }

    private int invalidate(NavigableSet<RelFile> filesInCache, RelFile pathToInvalidate, Cache<RelFile, ?> associatedCacheToClear) {
        RelFile rf;
        int count = 0;
        Iterator iterator = filesInCache.tailSet(pathToInvalidate).iterator();
        while (iterator.hasNext() && pathToInvalidate.isAncestorOf(rf = (RelFile)iterator.next())) {
            if (associatedCacheToClear != null) {
                associatedCacheToClear.invalidate((Object)rf);
            }
            iterator.remove();
            ++count;
        }
        return count;
    }

    @Override
    public synchronized void invalidate(RelFile pathToInvalidate) {
        int invalidatedCount = 0;
        invalidatedCount += this.invalidate(this.cachedFilePresences, pathToInvalidate, this.cachedContents);
        invalidatedCount += this.invalidate(this.cachedListings.navigableKeySet(), pathToInvalidate, null);
        invalidatedCount += this.invalidate(this.cachedAttributes.navigableKeySet(), pathToInvalidate, null);
        invalidatedCount += this.cachedListings.remove(MoreObjects.firstNonNull((Object)pathToInvalidate.getParent(), (Object)RelFile.root())) != null ? 1 : 0;
        if (this.metrics != null) {
            this.metrics.fileInvalidationMeter.mark((long)invalidatedCount);
        }
    }

    private synchronized void updateCache(RelFile file, FileContent content) throws IOException {
        boolean cacheable = this.cacheabilityFilter.accept(this, file);
        ConcreteRelFileAttribute attributes = new ConcreteRelFileAttribute(file, RelFileAttribute.FileType.FILE, System.currentTimeMillis(), content.getUncompressedLength());
        if (content.isPossiblyNotStoredInMemory() || !cacheable) {
            this.cachedContents.invalidate((Object)file);
        } else {
            this.cachedContents.put((Object)file, (Object)content);
        }
        if (cacheable) {
            this.cachedFilePresences.add(file);
            this.cachedAttributes.put(file, attributes);
            this.cachedListings.remove(MoreObjects.firstNonNull((Object)file.getParent(), (Object)RelFile.root()));
            if (this.metrics != null) {
                this.metrics.cacheUpdateMeter.mark();
            }
        }
    }

    @Override
    public synchronized void updateCache(Journal journal) throws IOException {
        for (RelFile rf : journal.deletedFiles) {
            this.invalidate(rf);
        }
        for (RelFile rf : journal.deletedDirectories) {
            this.invalidate(rf);
        }
        for (RelFile rf : journal.createdDirectories) {
            this.cachedListings.remove(MoreObjects.firstNonNull((Object)rf.getParent(), (Object)RelFile.root()));
        }
        for (Journal.WrittenFile wf : journal.getWrittenFiles()) {
            if (wf.content == null) continue;
            this.updateCache(wf.file, wf.content);
        }
    }

    @Override
    public void inspectionData(Appendable sb) throws IOException {
        for (Map.Entry entry : this.cachedContents.asMap().entrySet()) {
            sb.append(((RelFile)entry.getKey()).getFullPath()).append("\t");
            sb.append(((FileContent)entry.getValue()).inspectionData()).append("\n");
        }
    }

    @Override
    public synchronized String fullDumpItem(String path) {
        FileContent content = (FileContent)this.cachedContents.getIfPresent((Object)RelFile.fromPath(path));
        if (content != null) {
            return content.fullDumpObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory(RelFile file) throws IOException {
        boolean isPresenceCached;
        InMemoryCache inMemoryCache = this;
        synchronized (inMemoryCache) {
            if (Boolean.FALSE.equals(this.getCachedExists((RelFile)file).first)) {
                return false;
            }
            isPresenceCached = this.cachedFilePresences.contains(file);
        }
        return !isPresenceCached && super.isDirectory(file);
    }

    private class Metrics {
        Meter fileInvalidationMeter = new Meter();
        Meter cacheUpdateMeter = new Meter();

        private Metrics() {
        }

        void registerOn(String prefix, MetricRegistry registry) {
            HashMap<CallSite, Object> metricsToRegister = new HashMap<CallSite, Object>();
            metricsToRegister.put((CallSite)((Object)(prefix + ".fileInvalidation")), this.fileInvalidationMeter);
            metricsToRegister.put((CallSite)((Object)(prefix + ".cacheUpdate")), this.cacheUpdateMeter);
            metricsToRegister.put((CallSite)((Object)(prefix + ".bytesWeightKB")), new CachedGauge<Long>(5L, TimeUnit.MINUTES){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Long loadValue() {
                    long total = 0L;
                    InMemoryCache inMemoryCache = InMemoryCache.this;
                    synchronized (inMemoryCache) {
                        for (Map.Entry entry : InMemoryCache.this.cachedContents.asMap().entrySet()) {
                            FileContent ce = (FileContent)entry.getValue();
                            total += ce.getInMemoryLength() / 1024L;
                        }
                    }
                    return total;
                }
            });
            metricsToRegister.put((CallSite)((Object)(prefix + ".nbListings")), new CachedGauge<Long>(5L, TimeUnit.MINUTES){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Long loadValue() {
                    InMemoryCache inMemoryCache = InMemoryCache.this;
                    synchronized (inMemoryCache) {
                        return InMemoryCache.this.cachedListings.size();
                    }
                }
            });
            metricsToRegister.put((CallSite)((Object)(prefix + ".nbAttributes")), new CachedGauge<Long>(5L, TimeUnit.MINUTES){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Long loadValue() {
                    InMemoryCache inMemoryCache = InMemoryCache.this;
                    synchronized (inMemoryCache) {
                        return InMemoryCache.this.cachedAttributes.size();
                    }
                }
            });
            metricsToRegister.put((CallSite)((Object)(prefix + ".nbFilePresences")), new CachedGauge<Long>(5L, TimeUnit.MINUTES){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Long loadValue() {
                    InMemoryCache inMemoryCache = InMemoryCache.this;
                    synchronized (inMemoryCache) {
                        return InMemoryCache.this.cachedFilePresences.size();
                    }
                }
            });
            metricsToRegister.putAll(GuavaCacheMetrics.cacheMetricsSet(prefix, InMemoryCache.this.cachedContents).getMetrics());
            registry.removeMatching((name, metric) -> metricsToRegister.containsKey(name));
            registry.registerAll(() -> metricsToRegister);
        }
    }
}

