/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.InMemoryFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.j3ts.ClassScanner;
import com.dataiku.dip.utils.j3ts.TSFileEmitter;
import com.dataiku.dip.utils.j3ts.TSMappedType;
import com.dataiku.dip.utils.j3ts.TSTypeMapper;
import com.dataiku.dip.utils.j3ts.Translator;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TSTranslator
extends Translator {
    private final List<TSMappedType.ForeignMapping> foreignMappings = new ArrayList<TSMappedType.ForeignMapping>();
    private final HashMap<Class<?>, String> customMappings = new HashMap();

    public TSTranslator(File inputDirectory, File outputDirectory, boolean shouldGenerateMetadata) {
        super(inputDirectory, outputDirectory, shouldGenerateMetadata);
    }

    @Override
    public void translate() throws Exception {
        Stopwatch sw = Stopwatch.createStarted();
        for (ClassScanner.RootMapping rootMapping : this.rootMappings) {
            System.out.println("[+] Root mapping");
            System.out.println("[+]   - Scan from: " + rootMapping.directoryOrJarName);
            File outDir = rootMapping.targetDirectory != null ? new File(this.outputDirectory, rootMapping.targetDirectory.toString()) : this.outputDirectory;
            System.out.println("[+]   - Output in: " + String.valueOf(outDir));
        }
        for (TSMappedType.ForeignMapping foreignMapping : this.foreignMappings) {
            System.out.println("[+] Re-use already translated types");
            System.out.println("[+]   - From directory: " + String.valueOf(foreignMapping.sourceDirectory));
            System.out.println("[+]   - TS module name: " + foreignMapping.foreignModuleName);
        }
        System.out.println("[+] Output directory: " + this.outputDirectory.getAbsolutePath());
        ClassScanner classScanner = new ClassScanner(UIModel.class, this.rootMappings, this.inputDirectory);
        List<Class<?>> entryPoints = classScanner.scanEntryPoints();
        TSTypeMapper TSTypeMapper2 = new TSTypeMapper(classScanner, this.foreignMappings, this.customMappings);
        List<TSMappedType> exploredTypes = TSTranslator.exploreFromEntryPoints(TSTypeMapper2, entryPoints);
        InMemoryFS files = this.generateFiles(exploredTypes, classScanner, this.shouldGenerateMetadata);
        TSTranslator.syncChangesToDisk(files, this.outputDirectory);
        System.out.println("[+] Done! Total time: " + DKUtils.getElapsed((Stopwatch)sw));
    }

    public void addForeignMapping(File sourceDirectory, String foreignModuleName) throws IOException {
        File metadataFile = new File(sourceDirectory, "j3ts-generated-metadata.json");
        MetadataFile parsed = (MetadataFile)JSON.parseFile((File)metadataFile, MetadataFile.class);
        TSMappedType.ForeignMapping foreignMapping = new TSMappedType.ForeignMapping();
        foreignMapping.sourceDirectory = sourceDirectory;
        foreignMapping.javaToTs = new HashMap<String, TSMappedType.PersistedTypeMeta>();
        for (TSMappedType.PersistedTypeMeta meta : parsed.mappings) {
            foreignMapping.javaToTs.put(meta.javaType, meta);
        }
        foreignMapping.foreignModuleName = foreignModuleName;
        this.foreignMappings.add(foreignMapping);
    }

    private MetadataFile generateMetadata(List<TSMappedType> TSMappedTypes) {
        MetadataFile metadata = new MetadataFile();
        for (TSMappedType mt : TSMappedTypes) {
            if (mt.tsDefinitionFileNoExt == null || mt.foreignMapping != null) continue;
            metadata.mappings.add(mt.getPersistedTypeMeta());
        }
        metadata.mappings.sort(Comparator.comparing(o -> o.javaType));
        return metadata;
    }

    private InMemoryFS generateFiles(List<TSMappedType> mappedTypes, ClassScanner classScanner, boolean shouldGenerateMetadata) throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        TreeMap<RelFile, TSFileEmitter> files = new TreeMap<RelFile, TSFileEmitter>();
        TreeSet<RelFile> currentSourcePaths = new TreeSet<RelFile>();
        currentSourcePaths.add(classScanner.getSourceFileForClassIfExists(this.getClass()).getParent());
        TSFileEmitter indexFileEmitter = new TSFileEmitter(new RelFile("index"));
        files.put(indexFileEmitter.tsDefinitionFileNameNoExt, indexFileEmitter);
        for (TSMappedType tSMappedType : mappedTypes) {
            RelFile sourceFile = classScanner.getSourceFileForClassIfExists(tSMappedType.javaType);
            if (sourceFile != null) {
                currentSourcePaths.add(sourceFile);
            }
            if (tSMappedType.tsDefinitionFileNoExt == null || tSMappedType.foreignMapping != null) continue;
            TSFileEmitter emitter = (TSFileEmitter)files.get(tSMappedType.tsDefinitionFileNoExt);
            if (emitter == null) {
                emitter = new TSFileEmitter(new RelFile(tSMappedType.tsDefinitionFileNoExt));
                files.put(tSMappedType.tsDefinitionFileNoExt, emitter);
            }
            emitter.writeTypeDefinition(tSMappedType);
            if (!tSMappedType.addToIndex) continue;
            indexFileEmitter.addExport(tSMappedType);
        }
        InMemoryFS tmpFs = new InMemoryFS();
        for (TSFileEmitter emitter : files.values()) {
            tmpFs.writeStringUTF8(String.valueOf(emitter.tsDefinitionFileNameNoExt) + ".ts", emitter.generateCode());
        }
        if (shouldGenerateMetadata) {
            System.out.println("[+] Generate metadata");
            tmpFs.writeObject("j3ts-generated-metadata.json", this.generateMetadata(mappedTypes));
        } else {
            System.out.println("[+] Skip metadata generation");
        }
        System.out.println("[+] Generate best effort list of Java sources (" + currentSourcePaths.size() + " files)");
        tmpFs.writeStringUTF8("java-source-paths.txt", currentSourcePaths.stream().map(RelFile::getFullPath).collect(Collectors.joining("\n")));
        long l = FSUtils.calculateSize(tmpFs, RelFile.root()) / 1024L;
        System.out.println("[+] Generate TS files: " + DKUtils.getElapsed((Stopwatch)sw) + " (" + l + "kB)");
        return tmpFs;
    }

    private static List<TSMappedType> exploreFromEntryPoints(TSTypeMapper TSTypeMapper2, List<Class<?>> entryPoints) throws Exception {
        Stopwatch sw = Stopwatch.createStarted();
        for (Class<?> clazz : entryPoints) {
            TSTypeMapper2.mapTypeAndGenerateUnion(clazz);
        }
        List<TSMappedType> TSMappedTypes = TSTypeMapper2.getAllMappedTypes();
        System.out.println("[+] Translate types: " + DKUtils.getElapsed((Stopwatch)sw) + " (" + TSMappedTypes.size() + " types)");
        return TSMappedTypes;
    }

    private static class MetadataFile {
        List<TSMappedType.PersistedTypeMeta> mappings = new ArrayList<TSMappedType.PersistedTypeMeta>();

        private MetadataFile() {
        }
    }
}

