/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedDeletedArtifact;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.services.artifacts.IArtifactHistoryAwareService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IArtifactRoleAssignmentsDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.utils.Either;
import java.io.IOException;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactHistoryAwareService
implements IArtifactHistoryAwareService {
    @Autowired
    private IHistoryDataService historyDataService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private IArtifactRoleAssignmentsDataService artifactRoleAssignmentsDataService;

    @Override
    @GHReadonlyTransaction
    public Either<EnrichedArtifact, EnrichedDeletedArtifact> getHistoryAwareArtifact(String artifactId) throws IOException {
        EnrichedArtifact currentEnrichedArtifact = this.artifactsDataService.getArtifactOrNull(artifactId);
        return this.getHistoryAwareArtifact(currentEnrichedArtifact, (ExceptionUtils.ThrowingSupplier<EnrichedArtifactWithoutPermissions, IOException>)((ExceptionUtils.ThrowingSupplier)() -> this.historyDataService.getLastKnownEnrichedArtifact(artifactId)));
    }

    private Either<EnrichedArtifact, EnrichedDeletedArtifact> getHistoryAwareArtifact(@Nullable EnrichedArtifact currentEnrichedArtifact, ExceptionUtils.ThrowingSupplier<EnrichedArtifactWithoutPermissions, IOException> lastKnownEnrichedArtifactSupplier) throws IOException {
        if (currentEnrichedArtifact != null) {
            return Either.left(currentEnrichedArtifact);
        }
        return Either.right(this.getArtifactDeleted(lastKnownEnrichedArtifactSupplier));
    }

    @Override
    @GHReadonlyTransaction
    public AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtx(AuthCtx authCtx, Either<EnrichedArtifact, EnrichedDeletedArtifact> artifact) throws IOException {
        if (artifact.isLeft()) {
            return this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, artifact.getLeft());
        }
        return this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtArtifactDeletedLevel(authCtx, artifact.getRight());
    }

    @Override
    @GHReadonlyTransaction
    public AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtx(AuthCtx authCtx, @Nullable EnrichedArtifact currentEnrichedArtifact, ExceptionUtils.ThrowingSupplier<EnrichedArtifactWithoutPermissions, IOException> lastKnownEnrichedArtifactSupplier) throws IOException {
        return this.computeAssignedRolesAndPermissionsCtx(authCtx, this.getHistoryAwareArtifact(currentEnrichedArtifact, lastKnownEnrichedArtifactSupplier));
    }

    private EnrichedDeletedArtifact getArtifactDeleted(ExceptionUtils.ThrowingSupplier<EnrichedArtifactWithoutPermissions, IOException> lastKnownEnrichedArtifactSupplier) throws IOException {
        EnrichedArtifactWithoutPermissions lastKnownEnrichedArtifact = (EnrichedArtifactWithoutPermissions)lastKnownEnrichedArtifactSupplier.get();
        EnrichedBlueprint enrichedBlueprint = this.blueprintsDataService.getBlueprintOrNull(lastKnownEnrichedArtifact.blueprint.id);
        ArtifactRoleAssignments artifactRoleAssignments = this.artifactRoleAssignmentsDataService.getArtifactRoleAssignmentsOrNull(lastKnownEnrichedArtifact.artifact.id);
        return EnrichedDeletedArtifact.build(lastKnownEnrichedArtifact, enrichedBlueprint, artifactRoleAssignments);
    }
}

