/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.custom_pages;

import com.dataiku.gh.core.models.configuration.CustomPageOrderGovernConfiguration;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.custom_pages.ICustomPagesDataService;
import com.dataiku.gh.core.services.user_config.IUserConfigurationDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.custom_pages.ICustomPageDAO;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomPagesDataService
implements ICustomPagesDataService {
    @Autowired
    private ICustomPageDAO customPageDao;
    @Autowired
    private IUserConfigurationDataService userConfigurationDataService;
    @Autowired
    private IGovernConfigurationDataService governConfigurationDataService;

    @Override
    @GHReadonlyTransaction
    public CustomPage getCustomPage(String customPageId) throws IOException {
        return (CustomPage)this.customPageDao.getMandatory(customPageId);
    }

    @Override
    @GHReadonlyTransaction
    public List<CustomPage> listCustomPages() throws IOException {
        return this.customPageDao.list();
    }

    @Override
    @GHWriteTransaction
    public CustomPage storeCustomPage(CustomPage customPage, boolean creation) throws IOException {
        if (creation) {
            this.governConfigurationDataService.lockConfigurationItem("custom-page-order");
            this.customPageDao.create(customPage);
            CustomPageOrderGovernConfiguration customPageOrderGovernConfiguration = this.getOrder();
            customPageOrderGovernConfiguration.customPageIds.add(customPage.id);
            this.saveOrder(customPageOrderGovernConfiguration.customPageIds);
        } else {
            this.customPageDao.save(customPage);
        }
        return (CustomPage)this.customPageDao.getMandatory(customPage.id);
    }

    @Override
    @GHWriteTransaction
    public void deleteCustomPage(String customPageId) throws IOException {
        this.governConfigurationDataService.lockConfigurationItem("custom-page-order");
        this.customPageDao.delete(customPageId);
        CustomPageOrderGovernConfiguration customPageOrderGovernConfiguration = this.getOrder();
        customPageOrderGovernConfiguration.customPageIds.remove(customPageId);
        this.saveOrder(customPageOrderGovernConfiguration.customPageIds);
        this.userConfigurationDataService.removeCustomPageId(customPageId);
    }

    @Override
    @GHWriteTransaction
    public void upsertCustomPage(CustomPage customPage) throws IOException {
        this.storeCustomPage(customPage, !this.customPageDao.exists(customPage.id));
    }

    @Override
    @GHWriteTransaction
    public CustomPageOrderGovernConfiguration saveOrder(List<String> customPageOrder) throws IOException {
        this.governConfigurationDataService.lockConfigurationItem("custom-page-order");
        CustomPageOrderGovernConfiguration customPageOrderGovernConfiguration = CustomPageOrderGovernConfiguration.build(customPageOrder);
        this.validateCustomPageOrder(customPageOrderGovernConfiguration);
        return (CustomPageOrderGovernConfiguration)this.governConfigurationDataService.upsertConfigurationItem(customPageOrderGovernConfiguration);
    }

    @Override
    @GHReadonlyTransaction
    public CustomPageOrderGovernConfiguration getOrder() throws IOException {
        return (CustomPageOrderGovernConfiguration)this.governConfigurationDataService.getConfigurationItem("custom-page-order");
    }

    private void validateCustomPageOrder(CustomPageOrderGovernConfiguration customPageOrderGovernConfiguration) throws IOException {
        HashSet<String> customPagesFromOrder;
        Set existingPages = this.customPageDao.list().stream().map(customPage -> customPage.id).collect(Collectors.toSet());
        if (!existingPages.equals(customPagesFromOrder = new HashSet<String>(customPageOrderGovernConfiguration.customPageIds))) {
            HashSet missingFromOrder = new HashSet(existingPages);
            missingFromOrder.removeAll(customPagesFromOrder);
            if (!missingFromOrder.isEmpty()) {
                throw new ValidationException("Custom page order invalid: missing some custom pages: " + String.valueOf(missingFromOrder));
            }
            HashSet<String> nonExistingPages = new HashSet<String>(customPagesFromOrder);
            nonExistingPages.removeAll(existingPages);
            if (!nonExistingPages.isEmpty()) {
                throw new ValidationException("Custom page order invalid: custom pages not found: " + String.valueOf(nonExistingPages));
            }
        }
        HashSet singleIds = new HashSet();
        List duplicates = customPageOrderGovernConfiguration.customPageIds.stream().filter(id -> !singleIds.add(id)).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            throw new ValidationException("Custom page order invalid: custom pages at multiple positions: " + String.valueOf(duplicates));
        }
    }
}

