/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.computation.effective_permissions;

import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.configuration.DefaultBlueprintPermissionsGovernConfiguration;
import com.dataiku.gh.core.models.configuration.GovernConfiguration;
import com.dataiku.gh.core.models.roles.audit.RolesAndPermissionsAudit;
import com.dataiku.gh.core.models.roles.permissions.ArtifactPermissionsItem;
import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.models.roles.permissions.FieldPermissionsItem;
import com.dataiku.gh.core.models.roles.permissions.PermissionsItem;
import com.dataiku.gh.core.services.configuration.IGovernConfigurationDataService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.IUserBlueprintRoleAssignmentsComputationService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.effective_permissions.IEffectivePermissionsComputationService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EffectivePermissionsComputationService
implements IEffectivePermissionsComputationService {
    @Autowired
    private IGovernConfigurationDataService governConfigurationDataService;

    @Override
    @GHReadonlyTransaction
    public EffectivePermissionsItem computeEffectivePermissionsAtBlueprintLevel(Set<String> assignedRoles, boolean isGovernManager, boolean isArtifactsSystemLockEnabledForBlueprint, boolean blueprintExists, @Nullable BlueprintPermissions configuredBlueprintPermissions, @Nullable BlueprintVersion blueprintVersion, RolesAndPermissionsAudit.PermissionsAudit permissionsAudit) throws IOException {
        EffectivePermissionsItem effectivePermissions = this.computeEffectivePermissionsAtArtifactLevel(assignedRoles, isGovernManager, isArtifactsSystemLockEnabledForBlueprint, blueprintExists, configuredBlueprintPermissions, blueprintVersion, permissionsAudit);
        effectivePermissions.artifactPermissionsItem.read = effectivePermissions.artifactPermissionsItem.read || effectivePermissions.artifactPermissionsItem.create;
        return effectivePermissions;
    }

    @Override
    @GHReadonlyTransaction
    public EffectivePermissionsItem computeEffectivePermissionsAtBlueprintVersionLevel(Set<String> assignedRoles, boolean isGovernManager, boolean isArtifactsSystemLockEnabledForBlueprint, boolean blueprintExists, @Nullable BlueprintPermissions configuredBlueprintPermissions, @Nullable BlueprintVersion blueprintVersion, RolesAndPermissionsAudit.PermissionsAudit permissionsAudit) throws IOException {
        EffectivePermissionsItem effectivePermissions = this.computeEffectivePermissionsAtArtifactLevel(assignedRoles, isGovernManager, isArtifactsSystemLockEnabledForBlueprint, blueprintExists, configuredBlueprintPermissions, blueprintVersion, permissionsAudit);
        effectivePermissions.artifactPermissionsItem.read = effectivePermissions.artifactPermissionsItem.read || effectivePermissions.artifactPermissionsItem.create;
        return effectivePermissions;
    }

    @Override
    @GHReadonlyTransaction
    public EffectivePermissionsItem computeEffectivePermissionsAtArtifactLevel(Set<String> assignedRoles, boolean isGovernManager, boolean isArtifactsSystemLockEnabledForBlueprint, boolean blueprintExists, @Nullable BlueprintPermissions configuredBlueprintPermissions, @Nullable BlueprintVersion blueprintVersion, RolesAndPermissionsAudit.PermissionsAudit permissionsAudit) throws IOException {
        BlueprintPermissions blueprintPermissionsOrDefault = blueprintExists ? this.getBlueprintPermissionsOrDefault(configuredBlueprintPermissions, permissionsAudit) : null;
        List<Map.Entry<String, PermissionsItem>> matchingRolePermissions = blueprintExists && blueprintPermissionsOrDefault != null ? blueprintPermissionsOrDefault.rolePermissions.entrySet().stream().filter(e -> assignedRoles.contains(e.getKey())).collect(Collectors.toList()) : Collections.emptyList();
        EffectivePermissionsItem effectivePermissionsItem = this.buildArtifactPermissionsToPermissionsItem(isGovernManager, isArtifactsSystemLockEnabledForBlueprint, blueprintPermissionsOrDefault, matchingRolePermissions, permissionsAudit.artifactPermissionsAudit);
        if (blueprintVersion != null && !permissionsAudit.auditConfiguration.shouldBreak(effectivePermissionsItem.artifactPermissionsItem.hasNoPermissions())) {
            this.addFieldsPermissionsToPermissionsItem(effectivePermissionsItem, isGovernManager, isArtifactsSystemLockEnabledForBlueprint, blueprintPermissionsOrDefault, matchingRolePermissions, blueprintVersion, permissionsAudit);
        }
        return effectivePermissionsItem;
    }

    @Override
    @GHReadonlyTransaction
    public Map<String, EffectivePermissionsItem> computeAllUsersEffectivePermissionsAtArtifactLevel(List<IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole> assignedRoles, Map<String, Boolean> isGovernManager, boolean systemLocked, boolean blueprintExists, @Nullable BlueprintPermissions configuredBlueprintPermissions, @Nullable BlueprintVersion blueprintVersion, RolesAndPermissionsAudit multipleUsersRolesAndPermissionsAudit) throws IOException {
        HashMap rolesPerUser = new HashMap();
        for (IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole loginsForRole : assignedRoles) {
            for (String userLogin : loginsForRole.userLogins) {
                rolesPerUser.computeIfAbsent(userLogin, u -> new HashSet()).add(loginsForRole.role.id);
            }
        }
        HashMap<String, EffectivePermissionsItem> effectivePermissionsItems = new HashMap<String, EffectivePermissionsItem>();
        BlueprintPermissions blueprintPermissionsOrDefault = blueprintExists ? this.getBlueprintPermissionsOrDefault(configuredBlueprintPermissions, multipleUsersRolesAndPermissionsAudit.permissionsAudit) : null;
        for (String user : isGovernManager.keySet()) {
            RolesAndPermissionsAudit.ByUserAudit perUserRolesAndPermissionsAudit = multipleUsersRolesAndPermissionsAudit.byUserAudit(user);
            effectivePermissionsItems.put(user, this.computeEffectivePermissionsAtArtifactLevel(rolesPerUser.getOrDefault(user, Collections.emptySet()), isGovernManager.get(user), systemLocked, blueprintExists, blueprintPermissionsOrDefault, blueprintVersion, perUserRolesAndPermissionsAudit.permissionsAudit));
        }
        return effectivePermissionsItems;
    }

    private BlueprintPermissions getBlueprintPermissionsOrDefault(@Nullable BlueprintPermissions blueprintPermissions, RolesAndPermissionsAudit.PermissionsAudit permissionAudit) throws IOException {
        if (blueprintPermissions == null) {
            permissionAudit.declareUsedDefaultPermissions();
            GovernConfiguration defaultBpPermissionsGovernConfig = this.governConfigurationDataService.getConfigurationItem("default-blueprint-permissions");
            blueprintPermissions = ((DefaultBlueprintPermissionsGovernConfiguration)defaultBpPermissionsGovernConfig).defaultBlueprintPermissions;
        } else {
            permissionAudit.declareUsedBPPermissions();
        }
        permissionAudit.usedBlueprintPermissions = blueprintPermissions;
        return blueprintPermissions;
    }

    private EffectivePermissionsItem buildArtifactPermissionsToPermissionsItem(boolean isGovernManager, boolean systemLocked, @Nullable BlueprintPermissions blueprintPermissions, List<Map.Entry<String, PermissionsItem>> matchingRolePermissions, RolesAndPermissionsAudit.ArtifactPermissionsAudit permissionsAudit) {
        EffectivePermissionsItem effectivePermissionsItem;
        permissionsAudit.isGovernManager = isGovernManager;
        permissionsAudit.systemLocked = systemLocked;
        EffectivePermissionsItem effectivePermissionsItem2 = effectivePermissionsItem = isGovernManager ? EffectivePermissionsItem.build(ArtifactPermissionsItem.createWithAllPermissions(), systemLocked) : EffectivePermissionsItem.build(ArtifactPermissionsItem.createWithNoPermissions(), systemLocked);
        if (blueprintPermissions != null && !permissionsAudit.auditConfiguration.shouldBreak(effectivePermissionsItem.artifactPermissionsItem.hasAllPermissions())) {
            effectivePermissionsItem.artifactPermissionsItem.mergeWith(blueprintPermissions.everyonePermissions.artifactPermissionsItem);
            permissionsAudit.addEveryonePermissions(blueprintPermissions.everyonePermissions.artifactPermissionsItem);
        }
        if (!permissionsAudit.auditConfiguration.shouldBreak(effectivePermissionsItem.artifactPermissionsItem.hasAllPermissions())) {
            for (Map.Entry<String, PermissionsItem> rolePermissionsItem : matchingRolePermissions) {
                effectivePermissionsItem.artifactPermissionsItem.mergeWith(rolePermissionsItem.getValue().artifactPermissionsItem);
                permissionsAudit.addRolePermissions(rolePermissionsItem.getValue().artifactPermissionsItem, rolePermissionsItem.getKey());
                if (!permissionsAudit.auditConfiguration.shouldBreak(effectivePermissionsItem.artifactPermissionsItem.hasAllPermissions())) continue;
                break;
            }
        }
        if (systemLocked && !isGovernManager && !effectivePermissionsItem.artifactPermissionsItem.hasAdminPermission()) {
            effectivePermissionsItem.artifactPermissionsItem.create = false;
            effectivePermissionsItem.artifactPermissionsItem.delete = false;
            effectivePermissionsItem.artifactPermissionsItem.write = false;
            effectivePermissionsItem.artifactPermissionsItem.admin = false;
        }
        return effectivePermissionsItem;
    }

    private void addFieldsPermissionsToPermissionsItem(EffectivePermissionsItem effectivePermissionsItem, boolean isGovernManager, boolean isArtifactsSystemLockEnabledForBlueprint, @Nullable BlueprintPermissions blueprintPermissions, List<Map.Entry<String, PermissionsItem>> matchingRolePermissions, BlueprintVersion blueprintVersion, RolesAndPermissionsAudit.PermissionsAudit permissionsAudit) {
        for (String fieldId : blueprintVersion.fieldDefinitions.keySet()) {
            RolesAndPermissionsAudit.FieldPermissionAudit fieldPermissionAudit = permissionsAudit.addFieldPermissionAudit(fieldId);
            FieldPermissionsItem fieldPermissionsItem = FieldPermissionsItem.buildWithNoPermissions();
            fieldPermissionAudit.isGovernManager = isGovernManager;
            if (isGovernManager) {
                fieldPermissionsItem = FieldPermissionsItem.buildWithAllPermissions();
            }
            fieldPermissionAudit.isArtifactAdmin = effectivePermissionsItem.artifactPermissionsItem.hasAdminPermission();
            if (effectivePermissionsItem.artifactPermissionsItem.hasAdminPermission()) {
                fieldPermissionsItem = FieldPermissionsItem.buildWithAllPermissions();
            }
            if (blueprintPermissions != null && !permissionsAudit.auditConfiguration.shouldBreak(fieldPermissionsItem.hasAllPermissions())) {
                if (blueprintPermissions.everyonePermissions.fieldPermissionsItems.containsKey(fieldId)) {
                    FieldPermissionsItem everyonePermissions = blueprintPermissions.everyonePermissions.fieldPermissionsItems.get(fieldId);
                    fieldPermissionsItem.mergeWith(everyonePermissions);
                    fieldPermissionAudit.addEveryonePermissions(everyonePermissions);
                } else {
                    FieldPermissionsItem defaultPermissions = FieldPermissionsItem.build(blueprintPermissions.everyonePermissions.fieldsDefaultRead, blueprintPermissions.everyonePermissions.fieldsDefaultWrite);
                    fieldPermissionsItem.mergeWith(defaultPermissions);
                    fieldPermissionAudit.addEveryoneFieldDefaultPermissions(defaultPermissions);
                }
            }
            if (!permissionsAudit.auditConfiguration.shouldBreak(fieldPermissionsItem.hasAllPermissions())) {
                for (Map.Entry<String, PermissionsItem> rolePermissionsItem : matchingRolePermissions) {
                    PermissionsItem permissionsItem = rolePermissionsItem.getValue();
                    if (permissionsItem.fieldPermissionsItems.containsKey(fieldId)) {
                        FieldPermissionsItem rolePermissions = permissionsItem.fieldPermissionsItems.get(fieldId);
                        fieldPermissionsItem.mergeWith(rolePermissions);
                        fieldPermissionAudit.addRolePermissions(rolePermissions, rolePermissionsItem.getKey());
                    } else {
                        FieldPermissionsItem roleDefaultPermissions = FieldPermissionsItem.build(permissionsItem.fieldsDefaultRead, permissionsItem.fieldsDefaultWrite);
                        fieldPermissionsItem.mergeWith(roleDefaultPermissions);
                        fieldPermissionAudit.addRoleDefaultPermissions(roleDefaultPermissions, rolePermissionsItem.getKey());
                    }
                    if (!permissionsAudit.auditConfiguration.shouldBreak(fieldPermissionsItem.hasAllPermissions())) continue;
                    break;
                }
            }
            if (isArtifactsSystemLockEnabledForBlueprint && !isGovernManager && !effectivePermissionsItem.artifactPermissionsItem.hasAdminPermission()) {
                fieldPermissionsItem.write = false;
            }
            effectivePermissionsItem.fieldPermissionsItems.put(fieldId, fieldPermissionsItem);
        }
    }
}

