/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.security.GlobalAPIKeyUsersContainer;
import com.dataiku.gh.core.models.security.GroupUsersContainer;
import com.dataiku.gh.core.models.security.RoleUsersContainer;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.security.UsersContainersExtraction;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffRecurrenceConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffUser;
import com.dataiku.gh.core.models.signoff.SignoffUsersGroup;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.core.visitors.ISignoffConfigurationVisitor;
import org.apache.commons.lang3.StringUtils;

public class SignoffConfigurationValidator
implements ISignoffConfigurationVisitor {
    public final UsersContainersExtraction usersContainersExtraction = new UsersContainersExtraction();

    @Override
    public void visit(SignoffConfiguration signoffConfiguration) {
        ValidatorUtils.validateThat(signoffConfiguration.id != null, "SignoffConfiguration id cannot be null", new Object[0]);
        ValidatorUtils.validateThat(signoffConfiguration.id.blueprintVersionId != null, "SignoffConfiguration id.blueprintVersionId cannot be null", new Object[0]);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)signoffConfiguration.id.blueprintVersionId.blueprintId), "SignoffConfiguration id.blueprintVersionId.blueprintId cannot be empty", new Object[0]);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)signoffConfiguration.id.blueprintVersionId.versionId), "SignoffConfiguration id.blueprintVersionId.versionId cannot be empty", new Object[0]);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)signoffConfiguration.id.stepId), "SignoffConfiguration id.stepId cannot be empty", new Object[0]);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)signoffConfiguration.title), "SignoffConfiguration title is required", new Object[0]);
        long nbDistinctCommentersGroupsIds = signoffConfiguration.feedbackUsersGroups.stream().map(group -> group.id).filter(StringUtils::isNotBlank).distinct().count();
        ValidatorUtils.validateThat(nbDistinctCommentersGroupsIds == (long)signoffConfiguration.feedbackUsersGroups.size(), "Invalid sign-off configuration: some feedbacks groups ids are not uniques and/or empty", new Object[0]);
    }

    @Override
    public void visit(SignoffUsersGroup usersGroup) {
        ValidatorUtils.validateThat(IdentifiersUtils.isValidHumanReadableId(usersGroup.id), "Invalid users group id: '%s'", usersGroup.id);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)usersGroup.title), "Users group title is required", new Object[0]);
    }

    @Override
    public void visit(SignoffUser signoffUser) {
        ValidatorUtils.validateIsIsoOffsetDateTime(signoffUser.addedOn, "The addedOn has the wrong format '%s', use ISO date-time", signoffUser.addedOn);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)signoffUser.addedBy), "The addedBy login is required", new Object[0]);
    }

    @Override
    public void visit(UserUsersContainer userUsersContainer) {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)userUsersContainer.login), "Login of the user is required", new Object[0]);
        this.usersContainersExtraction.add(userUsersContainer);
    }

    @Override
    public void visit(RoleUsersContainer roleUsersContainer) {
        ValidatorUtils.validateThat(IdentifiersUtils.isValidRoleId(roleUsersContainer.roleId), "The role Id '%s' is invalid", roleUsersContainer.roleId);
        this.usersContainersExtraction.add(roleUsersContainer);
    }

    @Override
    public void visit(GroupUsersContainer groupUsersContainer) {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)groupUsersContainer.groupName), "Name of the group is required", new Object[0]);
        this.usersContainersExtraction.add(groupUsersContainer);
    }

    @Override
    public void visit(GlobalAPIKeyUsersContainer globalAPIKeyUsersContainer) {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)globalAPIKeyUsersContainer.globalAPIKeyId), "Api Key id is required", new Object[0]);
        this.usersContainersExtraction.add(globalAPIKeyUsersContainer);
    }

    @Override
    public void visit(SignoffRecurrenceConfiguration signoffRecurrenceConfiguration) {
        ValidatorUtils.validateThat(signoffRecurrenceConfiguration.years >= 0, "Recurrence interval attribute ('years') must be >= 0", new Object[0]);
        ValidatorUtils.validateThat(signoffRecurrenceConfiguration.months >= 0, "Recurrence interval attribute ('months') must be >= 0", new Object[0]);
        ValidatorUtils.validateThat(signoffRecurrenceConfiguration.weeks >= 0, "Recurrence interval attribute ('weeks') must be >= 0", new Object[0]);
        ValidatorUtils.validateThat(signoffRecurrenceConfiguration.days >= 0, "Recurrence interval attribute ('days') must be >= 0", new Object[0]);
        if (signoffRecurrenceConfiguration.activated) {
            ValidatorUtils.validateThat(signoffRecurrenceConfiguration.years + signoffRecurrenceConfiguration.months + signoffRecurrenceConfiguration.weeks + signoffRecurrenceConfiguration.days > 0, "A recurrence interval must be set (at least one of the following attributes: 'years', 'months', 'weeks', 'days' must be greater than 0)", new Object[0]);
        }
    }
}

