/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.visitors;

import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.util.List;
import java.util.Map;

public interface IFieldValueVisitor {
    default public void visit(Object fieldValue) {
        if (fieldValue != null) {
            if (fieldValue instanceof String) {
                this.visit((String)fieldValue);
            } else if (fieldValue instanceof Boolean) {
                this.visit((Boolean)fieldValue);
            } else if (fieldValue instanceof Double) {
                this.visit((Double)fieldValue);
            } else if (fieldValue instanceof List) {
                this.visit((List)fieldValue);
            } else if (fieldValue instanceof Map) {
                this.visit((Map)fieldValue);
            } else {
                throw new ValidationException("FieldValue type unknown: " + fieldValue.getClass().getName());
            }
        }
    }

    default public void visit(String stringFieldValue) {
    }

    default public void visit(Boolean booleanFieldValue) {
    }

    default public void visit(Double doubleFieldValue) {
    }

    default public void visit(List<Object> listFieldValue) {
    }

    default public void visit(Map<String, Object> mapFieldValue) {
    }
}

