/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.dao;

import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.gh.ApplicationConfigurator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableLong;
import org.springframework.stereotype.Service;

@Service
public class ImagesDAO {
    private RelFile originalPictureFile(String projectKey, String type, String id) {
        switch (type) {
            case "USER": {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"User id is not specified");
                return new RelFile(new String[]{"user-pictures", id + "-original.png"});
            }
        }
        throw new IllegalArgumentException("Wrong image type");
    }

    private File resizedPictureFile(String projectKey, String type, String id, String size) {
        if (type.equals("USER")) {
            return ApplicationConfigurator.getFile((String[])new String[]{"caches", "user-pictures", id, size + ".png"});
        }
        throw new IllegalArgumentException("Wrong image type");
    }

    public synchronized void clearCachedPictures(String projectKey, String type, String id) throws IOException {
        File f = null;
        if (!type.equals("USER")) {
            throw new IllegalArgumentException("Wrong image type");
        }
        f = ApplicationConfigurator.getFile((String[])new String[]{"caches", "user-pictures", id});
        if (f.isDirectory()) {
            DKUFileUtils.deleteDirectory((File)f);
        }
    }

    public synchronized void clearProjectCachedPictures(String projectKey) throws IOException {
        File f = ApplicationConfigurator.getFile((String[])new String[]{"caches", "pictures", projectKey});
        if (f.isDirectory()) {
            DKUFileUtils.deleteDirectory((File)f);
        }
    }

    public InputStream getResizedImage(String projectKey, String type, String id, String size, MutableLong lastModified) throws IOException {
        File f = this.resizedPictureFile(projectKey, type, id, size);
        if (f.isFile()) {
            lastModified.setValue(f.lastModified());
            return new FileInputStream(f);
        }
        return null;
    }

    public InputStream getOriginalImage(String projectKey, String type, String id, MutableLong lastModified) throws IOException {
        RelFile rf;
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isFile(rf = this.originalPictureFile(projectKey, type, id))) {
            lastModified.setValue(t.getLastModified(rf));
            return new ByteArrayInputStream(t.readBytes(rf));
        }
        return null;
    }

    public long getOriginalImageHash(String projectKey, String type, String id) throws IOException {
        RelFile rf;
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isFile(rf = this.originalPictureFile(projectKey, type, id))) {
            return t.getLastModified(rf);
        }
        return 0L;
    }

    public void setResizedImage(String projectKey, String type, String id, InputStream imgData, String size) throws IOException {
        File f = this.resizedPictureFile(projectKey, type, id, size);
        DKUFileUtils.mkdirsParent((File)f);
        try (FileOutputStream fos = new FileOutputStream(f);){
            IOUtils.copy((InputStream)imgData, (OutputStream)fos);
        }
    }

    public void setOriginalImage(String projectKey, String type, String id, InputStream imgData) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (t.exists(file = this.originalPictureFile(projectKey, type, id))) {
            t.deleteFile(file);
        }
        if (imgData != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)imgData, (OutputStream)baos);
            t.writeBytes(file, baos.toByteArray());
        }
    }

    public void removeOriginalImage(String projectKey, String type, String id) throws IOException {
        this.clearCachedPictures(projectKey, type, id);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile file = this.originalPictureFile(projectKey, type, id);
        if (t.exists(file)) {
            t.deleteFile(file);
        }
    }
}

