/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.lambda.model.serverconfig.BundledSMVersion;
import com.dataiku.lambda.model.serverconfig.DatasetResource;
import com.dataiku.lambda.model.serverconfig.EndpointServerSideConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ServiceGenContext {
    private String serviceId;
    private String generationId;
    private File serviceGenFolder;
    private LambdaServiceConfig config;
    private Map<String, EndpointServerSideConfig> serverEndpointConfigs;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.service.context");

    public ServiceGenContext(String serviceId, String generationId, File serviceGenFolder) throws IOException {
        this.serviceId = serviceId;
        this.generationId = generationId;
        this.serviceGenFolder = serviceGenFolder;
        this.config = (LambdaServiceConfig)JSON.parseFile((File)new File(serviceGenFolder, "config.json"), LambdaServiceConfig.class);
        this.serverEndpointConfigs = new HashMap<String, EndpointServerSideConfig>(this.config.endpoints.size());
    }

    public void setServerEndpointConfig(String endpointId, EndpointServerSideConfig config) {
        this.serverEndpointConfigs.put(endpointId, config);
    }

    public EndpointServerSideConfig getServerEndpointConfig(String endpointId) {
        return this.serverEndpointConfigs.get(endpointId);
    }

    public String getGenerationId() {
        return this.generationId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public LambdaServiceConfig getConfig() {
        return this.config;
    }

    public BundledSMVersion getModelConfig(String modelId) {
        for (BundledSMVersion model : this.config.stdModels) {
            if (!model.id.equals(modelId)) continue;
            return model;
        }
        throw new Error("Failed to find model config " + modelId);
    }

    public DatasetResource getDatasetResource(String resourceId) {
        for (DatasetResource dr : this.config.datasetResources) {
            if (!dr.resourceId.equals(resourceId)) continue;
            return dr;
        }
        throw new Error("Failed to find dataset resource " + resourceId);
    }

    public File getBaseFolder() {
        return this.serviceGenFolder;
    }

    public File getEndpointFolder(String endpointId) {
        return new File(this.serviceGenFolder, "endpoint-" + endpointId);
    }

    public File getFileInEndpointFolder(String endpointId, String ... chunks) {
        return new File(this.getEndpointFolder(endpointId), StringUtils.join((Object[])chunks, (String)"/"));
    }

    @Nonnull
    public List<String> getLibPathsInEndpointFolder(String endpointId) {
        File[] listedFiles;
        ArrayList<String> libPaths = new ArrayList<String>();
        File libFolder = this.getFileInEndpointFolder(endpointId, "lib");
        if (libFolder.isDirectory() && null != (listedFiles = libFolder.listFiles())) {
            for (File f : listedFiles) {
                libPaths.add(f.getAbsolutePath());
            }
        }
        return libPaths;
    }

    public File getModelFolder(String modelId) {
        assert (modelId != null);
        File f = new File(this.serviceGenFolder, "models/" + modelId);
        if (!f.isDirectory()) {
            throw new Error("Folder does not exist: " + String.valueOf(f));
        }
        return f;
    }

    public VariablesContext getVariablesContextOrNull() throws IOException {
        File vcFile = DKUFileUtils.getWithin((File)this.getBaseFolder(), (String[])new String[]{"variables_context.json"});
        if (vcFile.exists()) {
            return (VariablesContext)JSON.parseFile((File)vcFile, HierarchicalVariablesContext.class);
        }
        logger.info((Object)"No variables context found");
        return null;
    }

    public File getMLPluginsFolder() {
        return DKUFileUtils.getWithin((File)this.getBaseFolder(), (String[])new String[]{"ml-plugins-lib"});
    }

    public File getManagedFolderFolder(String folderRef) {
        File f = new File(new File(this.serviceGenFolder, "managed_folders"), folderRef);
        if (!f.isDirectory()) {
            throw new Error("Folder does not exist: " + String.valueOf(f));
        }
        return f;
    }
}

