/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.DatabricksException;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.http.FormRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.http.HttpClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.http.Response;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.OAuthResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.RefreshableTokenSource;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.oauth.Token;
import com.dataiku.dss.shadelibdatabricks.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelibdatabricks.com.google.common.base.Strings;
import com.dataiku.dss.shadelibdatabricks.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.LocalDateTime;

class OidcTokenSource
extends RefreshableTokenSource {
    private final HttpClient httpClient;
    private final String tokenUrl;
    private final ImmutableMap<String, String> params;

    public OidcTokenSource(HttpClient httpClient, String tokenUrl, String clientId, String resource, String clientAssertion, String clientAssertionType) {
        this.httpClient = httpClient;
        this.tokenUrl = tokenUrl;
        ImmutableMap.Builder<String, String> builder = new ImmutableMap.Builder<String, String>();
        OidcTokenSource.putIfDefined(builder, "grant_type", "client_credentials");
        OidcTokenSource.putIfDefined(builder, "resource", resource);
        OidcTokenSource.putIfDefined(builder, "client_id", clientId);
        OidcTokenSource.putIfDefined(builder, "client_assertion_type", clientAssertionType);
        OidcTokenSource.putIfDefined(builder, "client_assertion", clientAssertion);
        this.params = builder.build();
    }

    private static void putIfDefined(ImmutableMap.Builder<String, String> builder, String key, String value) {
        if (!Strings.isNullOrEmpty(value)) {
            builder.put(key, value);
        }
    }

    @Override
    protected Token refresh() {
        OAuthResponse resp;
        Response rawResp;
        try {
            rawResp = this.httpClient.execute(new FormRequest(this.tokenUrl, this.params));
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request auth token: " + e.getMessage(), e);
        }
        try {
            resp = new ObjectMapper().readValue(rawResp.getBody(), OAuthResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request auth token: corrupted token: " + e.getMessage());
        }
        if (resp.getErrorCode() != null) {
            throw new IllegalArgumentException(resp.getErrorCode() + ": " + resp.getErrorSummary());
        }
        LocalDateTime expiry = LocalDateTime.now().plusSeconds(resp.getExpiresIn());
        return new Token(resp.getAccessToken(), resp.getTokenType(), resp.getRefreshToken(), expiry);
    }
}

