/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.metadatadomain;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.delta.kernel.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.delta.kernel.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.Optional;

public abstract class JsonMetadataDomain {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule(new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    protected static <T> T fromJsonConfiguration(String string, Class<T> clazz) {
        try {
            return OBJECT_MAPPER.readValue(string, clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new KernelException(String.format("Failed to parse JSON string into a %s instance. JSON content: %s", clazz.getSimpleName(), string), jsonProcessingException);
        }
    }

    protected static <T> Optional<T> fromSnapshot(SnapshotImpl snapshotImpl, Class<T> clazz, String string) {
        return Optional.ofNullable(snapshotImpl.getDomainMetadataMap().get(string)).filter(domainMetadata -> !domainMetadata.isRemoved()).map(domainMetadata -> JsonMetadataDomain.fromJsonConfiguration(domainMetadata.getConfiguration(), clazz));
    }

    @JsonIgnore
    public abstract String getDomainName();

    public String toJsonConfiguration() {
        try {
            return OBJECT_MAPPER.writeValueAsString(this);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new KernelException(String.format("Could not serialize %s (domain: %s) to JSON", this.getClass().getSimpleName(), this.getDomainName()), jsonProcessingException);
        }
    }

    public DomainMetadata toDomainMetadata() {
        return new DomainMetadata(this.getDomainName(), this.toJsonConfiguration(), false);
    }
}

