/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public abstract class SMMgmtService {
    public abstract List<FullModelId> listUsableVersions(SavedModel var1);

    public FullModelId getActiveVersionFMI(SavedModel sm) {
        if (StringUtils.isBlank((String)sm.activeVersion)) {
            throw ErrorContext.iae((String)String.format("No active version for model %s", sm.getId()));
        }
        FullModelId activeFmi = new FullModelId(sm.projectKey, sm.id, sm.activeVersion);
        if (!activeFmi.isModelUsable()) {
            throw ErrorContext.iae((String)String.format("Did not find active version %s for model %s", sm.activeVersion, sm.getId()));
        }
        return activeFmi;
    }

    public FullModelId getLatestVersionFMI_NT(SavedModel sm) {
        TransactionContext.assertNoAttachedTransaction();
        if (sm.savedModelType.isAgent()) {
            throw new IllegalArgumentException("Getting latest fmi is not supported for Agents");
        }
        if (sm.savedModelType.isRetrievalAugmentedLlm()) {
            throw new IllegalArgumentException("Getting latest fmi is not supported for Retrieval Augmented LLMs");
        }
        FullModelId latestFmi = null;
        long lastEndTime = 0L;
        for (FullModelId fmi : this.listUsableVersions(sm)) {
            long fmiEndTime;
            Optional<ModelTrainInfo> trainInfo = fmi.getTrainModelInfo();
            if (!trainInfo.isPresent() || (fmiEndTime = trainInfo.get().endTime) <= lastEndTime) continue;
            latestFmi = fmi;
            lastEndTime = fmiEndTime;
        }
        if (latestFmi != null) {
            return latestFmi;
        }
        throw ErrorContext.iae((String)String.format("Did not find latest version for model %s", sm.getId()));
    }

    public static List<File> listVersionFolders(SavedModel savedModel) {
        File baseFolder = MLPaths.savedModelVersionsFolder(savedModel);
        if (!baseFolder.isDirectory()) {
            return Collections.emptyList();
        }
        File[] versionFolders = baseFolder.listFiles((FileFilter)DKUFileUtils.FileFilter.DIRECTORIES);
        if (versionFolders == null) {
            return Collections.emptyList();
        }
        return List.of(versionFolders);
    }
}

