/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionScoringJobDef;
import com.dataiku.dip.analysis.ml.prediction.flow.TabularPredictionScoringRecipePayloadParams;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class PredictionScoringJobDefBuilder {
    @Autowired
    private VariablesService variablesSevice;
    @Autowired
    private JobAuthCtxService authCtxService;
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private final RecipeRunnableSubgraph subgraph;
    private final TabularPredictionScoringRecipePayloadParams params;
    private final ResourcesGatherer gatherer;
    private final String projectKey;

    public PredictionScoringJobDefBuilder(JobActivity activity, TabularPredictionScoringRecipePayloadParams params, ResourcesGatherer gatherer) {
        this.params = params;
        this.activity = activity;
        this.gatherer = gatherer;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        this.projectKey = this.recipe.getProjectKey();
        SpringUtils.getInstance().autowire((Object)this);
    }

    public PredictionScoringJobDef build() throws Exception {
        List<FlowDataset> inputFDS = this.activity.getSubgraph().getSourceDatasets();
        if (inputFDS.size() == 0) {
            throw ErrorContext.iae((String)"Missing input dataset in scoring recipe");
        }
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        MLFlowUtils.PredictionScoringRecipeStatusComputer computer = new MLFlowUtils.PredictionScoringRecipeStatusComputer(this.recipe.getModel(), JSON.json((Object)this.params));
        MLFlowUtils.PredictionScoringRecipeScorability scorability = computer.getScorability_T(authCtx, this.activity);
        ClassicalPredictionModelDetails details = PredictionResultsReader.makeDetails(scorability.fmi);
        SerializedShakerScript script = (SerializedShakerScript)JSON.parseFile((File)new File(scorability.activeModelFolder, "script.json"), SerializedShakerScript.class);
        script.contextProjectKey = scorability.model.projectKey;
        FlowDataset inputFD = this.subgraph.getSourceDataset(scorability.inputDataset.getFullName());
        FlowDataset outputFD = this.subgraph.getTargetDataset(scorability.outputDataset.getFullName());
        List<Partition> inputPartitions = this.subgraph.getSourcePartitions(inputFD);
        Partition outputPartition = this.subgraph.getTargetPartition(outputFD);
        Schema preparationOSchemaToUse = MLFlowUtils.getSchemaToUseForPreparedScoringInput(details.preprocessing, details.splitDesc.schema, scorability.inferredPreparedSchema, false, false, this.activity);
        PredictionScoringJobDef jobDef = new PredictionScoringJobDef();
        SerializedShakerScript expandedScript = script.expandedDeepCopy(this.variablesSevice.getForProject(this.projectKey));
        this.gatherer.gatherResources(expandedScript.steps);
        this.gatherer.dumpAndGatherAdditionalDatasets(authCtx, this.projectKey, expandedScript.steps);
        this.gatherer.dumpAndGatherPythonProcessors();
        this.gatherer.dumpAndGatherYarnPythonBins(expandedScript.steps, this.projectKey, authCtx);
        InputDatasetsReadParams readParams = new InputDatasetsReadParams();
        InputDatasetsReadParams.InputDatasetReadParams inputReadParams = new InputDatasetsReadParams.InputDatasetReadParams();
        inputReadParams.repartition = this.params.sparkParams.sparkRepartitionNonHDFS;
        readParams.map.put(DatasetLocUtils.resolveFull(scorability.inputDataset.getFullName()).getSmartName(this.recipe.getProjectKey()), inputReadParams);
        FlowDatasetRef inputRef = SparkRecipeUtils.getInputFlowDatasetRef(scorability.inputDataset, readParams, false, this.recipe, inputPartitions);
        FlowDatasetRef outputRef = SparkRecipeUtils.getOutputFlowDatasetRef(scorability.outputDataset, this.projectKey, outputPartition);
        jobDef.input = inputRef;
        jobDef.output = outputRef;
        jobDef.projectKey = this.recipe.getProjectKey();
        jobDef.activeModelFolder = scorability.activeModelFolder.getAbsolutePath();
        jobDef.fmi = scorability.fmi;
        jobDef.modelPartitionMode = scorability.modelPartitionMode;
        jobDef.readParams = readParams;
        jobDef.script = expandedScript;
        jobDef.desc = this.params;
        jobDef.prepOutSchema = preparationOSchemaToUse;
        return jobDef;
    }

    static {
        ScriptStep.loadClass();
    }
}

