/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DeepHubColumnFormat {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.analysis.data_format");

    public static List<ObjectDetectionTargetItem> parseObjectDetectionTarget(String odTargetStr) {
        if (StringUtils.isBlank((String)odTargetStr)) {
            return new ArrayList<ObjectDetectionTargetItem>();
        }
        return (List)JSON.parse((String)odTargetStr, (TypeToken)new TypeToken<List<ObjectDetectionTargetItem>>(){});
    }

    public static List<ObjectDetectionPredictedItem> parseObjectDetectionPrediction(String odPrediction) {
        if (StringUtils.isBlank((String)odPrediction)) {
            return new ArrayList<ObjectDetectionPredictedItem>();
        }
        return (List)JSON.parse((String)odPrediction, (TypeToken)new TypeToken<List<ObjectDetectionPredictedItem>>(){});
    }

    public static List<PairingItem> parseObjectDetectionPairing(String odPairing) {
        if (StringUtils.isBlank((String)odPairing)) {
            return new ArrayList<PairingItem>();
        }
        return (List)JSON.parse((String)odPairing, (TypeToken)new TypeToken<List<PairingItem>>(){});
    }

    public static class ObjectDetectionTargetParser {
        private static final int MAX_WARNING_MESSAGES = 50;
        private int numWarnings = 0;

        public List<ObjectDetectionTargetItem> parse(String odTargetStr) {
            try {
                List<ObjectDetectionTargetItem> parsed = DeepHubColumnFormat.parseObjectDetectionTarget(odTargetStr);
                parsed.forEach(ObjectDetectionTargetItem::check);
                return parsed;
            }
            catch (BadColumnFormatException | JsonSyntaxException e) {
                if (this.numWarnings < 50) {
                    logger.warn((Object)("Failed to parse column as bounding box, value=" + odTargetStr), e);
                    ++this.numWarnings;
                } else if (this.numWarnings == 50) {
                    logger.warn((Object)"Too many failures to parse column as bounding box, skipping next warnings");
                    ++this.numWarnings;
                }
                return null;
            }
        }
    }

    @UIModel
    public static class EnrichedObjectDetectionPairedItem {
        public double iou;
        public ObjectDetectionPredictedItem detection;
        public ObjectDetectionTargetItem groundTruth;

        public EnrichedObjectDetectionPairedItem(double iou, ObjectDetectionPredictedItem detection, ObjectDetectionTargetItem groundTruth) {
            this.iou = iou;
            this.detection = detection;
            this.groundTruth = groundTruth;
        }

        public EnrichedObjectDetectionPairedItem(ObjectDetectionTargetItem groundTruth) {
            this.groundTruth = groundTruth;
        }

        public EnrichedObjectDetectionPairedItem(ObjectDetectionPredictedItem detection) {
            this.detection = detection;
        }
    }

    @UIModel
    public static class PairingItem {
        public int gt_id;
        public int det_id;
        public double iou;
    }

    @UIModel
    public static class ObjectDetectionPredictedItem
    extends ObjectDetectionTargetItem {
        public float confidence;

        @Override
        public void check() {
            super.check();
            if (this.confidence < 0.0f || this.confidence > 1.0f) {
                throw new BadColumnFormatException("confidence is out of (0, 1) interval: " + this.confidence);
            }
        }
    }

    @UIModel
    public static class ObjectDetectionTargetItem {
        public String category;
        public float[] bbox;

        public void check() {
            if (StringUtils.isBlank((String)this.category)) {
                throw new BadColumnFormatException("Category is empty");
            }
            if (this.bbox == null) {
                throw new BadColumnFormatException("Bbox is null");
            }
            if (this.bbox.length != 4) {
                throw new BadColumnFormatException("Wrong length for bbox: should be of size 4, is of size " + this.bbox.length);
            }
            if (this.bbox[0] < 0.0f || this.bbox[1] < 0.0f || this.bbox[2] <= 0.0f || this.bbox[3] <= 0.0f) {
                throw new BadColumnFormatException("Wrong bbox format, expecting COCO like [x0, y0, w, h] format bbox is " + Arrays.toString(this.bbox));
            }
        }
    }

    static class BadColumnFormatException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public BadColumnFormatException(String message) {
            super(message);
        }
    }
}

