/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual;

import com.dataiku.dip.apideployer.datamodel.actual.common.DeploymentResourceComparator;
import com.dataiku.dip.apideployer.deployments.FullyManagedAPIServiceDeploymentConfigManager;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.CollectorUtils;
import com.dataiku.dip.utils.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

public abstract class AbstractFullyManagedResourceWithTagsComparator {
    protected abstract Map<String, String> getStoredTags();

    protected String getSeparatorOfDssVersionsInTags() {
        return ".";
    }

    public boolean areTagsOutOfSync(@Nonnull Map<String, String> deployedTags) {
        return !CollectionUtils.equalsOrBothEmpty(deployedTags, this.getStoredTags());
    }

    public Set<String> reportOutOfSyncNonDSSTags(@Nonnull Map<String, String> deployedTags) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        Map filteredStoredTagsMap = (Map)this.getStoredTags().entrySet().stream().filter(e -> !FullyManagedAPIServiceDeploymentConfigManager.DSS_TAG_KEYS.contains(e.getKey())).collect(CollectorUtils.toMap());
        Map filteredDeployedTagsMap = (Map)deployedTags.entrySet().stream().filter(e -> !FullyManagedAPIServiceDeploymentConfigManager.DSS_TAG_KEYS.contains(e.getKey())).collect(CollectorUtils.toMap());
        if (!CollectionUtils.equalsOrBothEmpty((Map)filteredDeployedTagsMap, (Map)filteredStoredTagsMap)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Tags", filteredDeployedTagsMap, filteredStoredTagsMap));
        }
        return outOfSyncFields;
    }

    protected Set<String> reportMissingDSSTags(@Nonnull Map<String, String> deployedTags) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (!deployedTags.keySet().containsAll(FullyManagedAPIServiceDeploymentConfigManager.DSS_TAG_KEYS)) {
            HashSet<String> missingDssTagKeys = new HashSet<String>(FullyManagedAPIServiceDeploymentConfigManager.DSS_TAG_KEYS);
            missingDssTagKeys.removeAll(deployedTags.keySet());
            outOfSyncFields.add(String.format("The DSS tags with keys %s has been removed from the resources.", missingDssTagKeys));
        }
        return outOfSyncFields;
    }

    protected Set<String> reportOutOfSyncDSSTags(@Nonnull Map<String, String> deployedTags) {
        String storedEndpointId;
        String deployedEndpointId;
        String storedDSSMajorVersion;
        String deployedDSSMajorVersion;
        String storedGeneration;
        HashSet<String> outOfSyncFields = new HashSet<String>();
        String deployedGeneration = deployedTags.get("dss_generation");
        if (!StringUtils.equalsOrBothBlank((String)deployedGeneration, (String)(storedGeneration = this.getStoredTags().get("dss_generation")))) {
            StringJoiner joiner = new StringJoiner(" ");
            joiner.add(DeploymentResourceComparator.outOfSyncFieldMessage("Generation", deployedGeneration, storedGeneration)).add(String.format("NOTE: The loaded test queries and endpoints correspond to the deployed version '%s'.", deployedGeneration));
            outOfSyncFields.add(joiner.toString());
        }
        if (!StringUtils.equalsOrBothBlank((String)(deployedDSSMajorVersion = this.getDSSMajorVersionFromSanitizedTag(deployedTags.get("dss_version"))), (String)(storedDSSMajorVersion = this.getDSSMajorVersionFromSanitizedTag(this.getStoredTags().get("dss_version"))))) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("DSS major version", deployedDSSMajorVersion, storedDSSMajorVersion));
        }
        if (!StringUtils.equalsOrBothBlank((String)(deployedEndpointId = deployedTags.get("dss_endpoint_id")), (String)(storedEndpointId = this.getStoredTags().get("dss_endpoint_id")))) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("DSS Endpoint id", deployedEndpointId, storedEndpointId));
        }
        return outOfSyncFields;
    }

    private String getDSSMajorVersionFromSanitizedTag(String versionTag) {
        if (versionTag == null) {
            return null;
        }
        String[] deployedDSSVersionComponents = org.apache.commons.lang.StringUtils.splitByWholeSeparator((String)versionTag, (String)this.getSeparatorOfDssVersionsInTags());
        return deployedDSSVersionComponents.length > 0 ? deployedDSSVersionComponents[0] : "";
    }
}

