/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.common;

import com.dataiku.dip.apideployer.datamodel.actual.common.ComparisonItem;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.utils.CollectorUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.StringUtils;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DeploymentResourceComparator<T> {
    public static final String CENSORED_STRING_PLACEHOLDER = "****";

    public static String outOfSyncFieldMessage(@Nonnull String field, @Nullable Object deployed, @Nullable Object stored) {
        return String.format("Configuration field '%s' is currently deployed with the value '%s' but the value in the local configuration is '%s'.", field, Objects.toString(deployed, ""), Objects.toString(stored, ""));
    }

    @Nonnull
    public static Set<String> compareResources(@Nonnull Collection<ComparisonItem> items) {
        String template = "Actual deployment's \"%s\" property value is %s, but the value in %s settings is %s.";
        HashSet<String> messages = new HashSet<String>();
        for (ComparisonItem item : items) {
            if (StringUtils.nullIfBlank((String)item.expected) == null || Objects.equals(item.actual, item.expected)) continue;
            messages.add(String.format(template, item.descriptor, item.actual == null ? "not specified" : String.format("\"%s\"", item.actual), item.isDeploymentSetting ? "deployment" : "infrastructure", String.format("\"%s\"", item.expected)));
        }
        return messages;
    }

    @Nonnull
    public static Set<SimpleKeyValue> censorValues(@Nullable Collection<SimpleKeyValue> target) {
        if (target == null) {
            return Collections.emptySet();
        }
        return target.stream().map(e -> new SimpleKeyValue(e.key, CENSORED_STRING_PLACEHOLDER)).collect(Collectors.toSet());
    }

    @Nonnull
    public static Map<String, String> censorValues(@Nullable Map<String, String> target) {
        if (target == null) {
            return Collections.emptyMap();
        }
        return (Map)target.keySet().stream().map(k -> new AbstractMap.SimpleEntry<String, String>((String)k, CENSORED_STRING_PLACEHOLDER)).collect(CollectorUtils.toMap());
    }

    public static Pair<String, String> splitModelImageName(String modelImageName) {
        String registryHost = "";
        String imageAlias = modelImageName;
        int hostSeparatorIndex = modelImageName.indexOf("/");
        if (hostSeparatorIndex > 0) {
            registryHost = modelImageName.substring(0, hostSeparatorIndex);
            imageAlias = modelImageName.substring(hostSeparatorIndex + 1);
        }
        return new Pair((Object)registryHost, (Object)imageAlias);
    }

    public static String getImageNameWithPrefix(String imageAlias) {
        String imageNameWithPrefix = imageAlias;
        int aliasSeparatorIndex = imageAlias.lastIndexOf(":");
        if (aliasSeparatorIndex > 0) {
            imageNameWithPrefix = imageAlias.substring(0, aliasSeparatorIndex);
        }
        return imageNameWithPrefix;
    }

    public static Set<String> reportOutOfSyncImageNameFields(String storedImage, String deployedImage) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (!StringUtils.equalsOrBothBlank((String)storedImage, (String)deployedImage)) {
            String storedImageNameWithPrefix;
            String deployedImageNameWithPrefix;
            Pair<String, String> deployedRegistryHostAndImageAlias = DeploymentResourceComparator.splitModelImageName(deployedImage);
            Pair<String, String> storedRegistryHostAndImageAlias = DeploymentResourceComparator.splitModelImageName(storedImage);
            if (!StringUtils.equalsOrBothBlank((String)((String)deployedRegistryHostAndImageAlias.first), (String)((String)storedRegistryHostAndImageAlias.first))) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Registry host", deployedRegistryHostAndImageAlias.first, storedRegistryHostAndImageAlias.first));
            }
            if (!StringUtils.equalsOrBothBlank((String)(deployedImageNameWithPrefix = DeploymentResourceComparator.getImageNameWithPrefix((String)deployedRegistryHostAndImageAlias.second)), (String)(storedImageNameWithPrefix = DeploymentResourceComparator.getImageNameWithPrefix((String)storedRegistryHostAndImageAlias.second)))) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Images prefix", deployedImageNameWithPrefix, storedImageNameWithPrefix));
            }
        }
        return outOfSyncFields;
    }

    public Set<String> reportRecoverableOutOfSyncFields(@Nonnull T var1);

    public Set<String> reportUnrecoverableOutOfSyncFields(@Nonnull T var1);

    default public boolean isOutOfSync(@Nonnull T otherResource) {
        return this.isOutOfSyncRecoverable(otherResource) || this.isOutOfSyncUnrecoverable(otherResource);
    }

    default public boolean isOutOfSyncUnrecoverable(@Nonnull T otherResource) {
        return !this.reportUnrecoverableOutOfSyncFields(otherResource).isEmpty();
    }

    default public boolean isOutOfSyncRecoverable(@Nonnull T otherResource) {
        return !this.reportRecoverableOutOfSyncFields(otherResource).isEmpty();
    }

    default public Set<String> reportOutOfSyncFields(@Nonnull T otherResource) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        outOfSyncFields.addAll(this.reportUnrecoverableOutOfSyncFields(otherResource));
        outOfSyncFields.addAll(this.reportRecoverableOutOfSyncFields(otherResource));
        return outOfSyncFields;
    }
}

