/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractFullyManagedAPIDeploymentInfra
extends AbstractAPIDockerDeploymentInfra {
    @Nullable
    public String authConnection;
    @Nonnull
    public List<SimpleKeyValue> environmentVars = new ArrayList<SimpleKeyValue>();
    @Nonnull
    public List<SimpleKeyValue> tags = new ArrayList<SimpleKeyValue>();
    public boolean allowOverrideSizeAndScaling = false;
    public boolean allowOverrideTags = false;

    AbstractFullyManagedAPIDeploymentInfra() {
    }

    AbstractFullyManagedAPIDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
        this.defaultApiNodeLogging.auditLog.logQueries = false;
    }

    public abstract void trySetDefaultValues_NT();

    private static AbstractFullyManagedAPIDeploymentInfra buildFullyManagedInfra(AbstractDeploymentInfra.InfraType infraType, String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        if (AbstractDeploymentInfra.InfraType.AZURE_ML.equals((Object)infraType)) {
            return new AzureMLAPIDeploymentInfra(id, stage, userIdentifier, governCheckPolicy);
        }
        if (AbstractDeploymentInfra.InfraType.DATABRICKS.equals((Object)infraType)) {
            return new DatabricksAPIDeploymentInfra(id, stage, userIdentifier, governCheckPolicy);
        }
        if (AbstractDeploymentInfra.InfraType.SAGEMAKER.equals((Object)infraType)) {
            return new SageMakerAPIDeploymentInfra(id, stage, userIdentifier, governCheckPolicy);
        }
        if (AbstractDeploymentInfra.InfraType.VERTEX_AI.equals((Object)infraType)) {
            return new VertexAIAPIDeploymentInfra(id, stage, userIdentifier, governCheckPolicy);
        }
        if (AbstractDeploymentInfra.InfraType.SNOWPARK.equals((Object)infraType)) {
            return new SnowparkAPIDeploymentInfra(id, stage, userIdentifier, governCheckPolicy);
        }
        throw ErrorContext.iae((String)("Unsupported infra type: " + String.valueOf((Object)infraType)));
    }

    public static AbstractFullyManagedAPIDeploymentInfra buildFullyManagedInfraWithDefaultValues_NT(AbstractDeploymentInfra.InfraType infraType, String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        AbstractFullyManagedAPIDeploymentInfra infra = AbstractFullyManagedAPIDeploymentInfra.buildFullyManagedInfra(infraType, id, stage, userIdentifier, governCheckPolicy);
        infra.trySetDefaultValues_NT();
        infra.buildIntermediateImageWithCodeEnvs = true;
        infra.defaultApiNodeLogging.redirectToPod = true;
        return infra;
    }

    abstract EndpointType getEndpointType();

    public boolean isServerless() {
        return this.getEndpointType().equals((Object)EndpointType.SERVERLESS);
    }

    public String getDisplayedConnectionName() {
        return this.authConnection != null ? this.authConnection : "ENVIRONMENT";
    }

    public static enum EndpointType {
        REAL_TIME,
        SERVERLESS;

    }
}

