/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deploymentinfo;

import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.AbstractDeploymentInfo;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksRegisteredModelVersion;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetails;
import com.dataiku.dip.savedmodels.externalmodelidentifier.DatabricksEndpointIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatabricksDeploymentInfo
extends AbstractDeploymentInfo {
    @Nullable
    public String dbxModelName;
    @Nullable
    public String dbxModelVersion;
    @Nullable
    public String dbxExperimentName;
    @Nullable
    public String dbxExperimentId;
    @Nullable
    public String dbxExperimentRunId;
    @Nullable
    public String dbxEndpointName;
    @Nullable
    public String dbxEndpointId;
    @Nullable
    public String dbxHostBaseUrl;
    public boolean usesUnityCatalog;

    public DatabricksDeploymentInfo() {
    }

    public DatabricksDeploymentInfo(DatabricksAPIDeploymentInfra infra, DatabricksAPIDeployment deployment) {
        super(infra.id, deployment.id, null);
    }

    public DatabricksDeploymentInfo(DatabricksAPIDeploymentInfra infra, DatabricksAPIDeployment deployment, @Nullable String hostBaseUrl, @Nonnull DatabricksRegisteredModelVersion modelVersion, @Nonnull String experimentName, @Nullable String experimentId, @Nonnull DatabricksServingEndpointDetails endpointDetails) {
        this(infra, deployment);
        this.dbxHostBaseUrl = hostBaseUrl;
        this.dbxModelName = modelVersion.name;
        this.dbxModelVersion = modelVersion.version;
        this.dbxEndpointName = endpointDetails.name;
        this.dbxEndpointId = endpointDetails.id;
        this.usesUnityCatalog = deployment.usesUnityCatalog(infra);
        this.dbxExperimentName = experimentName;
        this.dbxExperimentId = experimentId;
        this.dbxExperimentRunId = modelVersion.runId;
    }

    @Override
    @Nullable
    public DatabricksEndpointIdentifier getExternalEndpointIdentifier() {
        return new DatabricksEndpointIdentifier(this.dbxEndpointId, this.dbxHostBaseUrl, this.dbxEndpointName);
    }
}

