/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ClusterPropertyList
extends ArrayList<ClusterProperty> {
    private static final long serialVersionUID = 1L;

    public ClusterPropertyList() {
    }

    public ClusterPropertyList(ClusterPropertyList list) {
        list.forEach((? super E p) -> this.add(p.deepCopy()));
    }

    public ClusterPropertyList deepCopy() {
        return new ClusterPropertyList(this);
    }

    public List<SimpleKeyValue> getAsSimpleKeyValueList() {
        ArrayList ret = Lists.newArrayList();
        for (ClusterProperty kv : this) {
            ret.add(new SimpleKeyValue(kv.key, kv.value));
        }
        return ret;
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getAsConnectionProperties() {
        ArrayList ret = Lists.newArrayList();
        for (ClusterProperty kv : this) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(kv.key, kv.value, kv.secret));
        }
        return ret;
    }

    private Map<String, ClusterProperty> getIndexedByKey() {
        HashMap byKey = Maps.newHashMap();
        for (ClusterProperty prop : this) {
            if (StringUtils.isBlank((String)prop.key)) continue;
            byKey.put(prop.key, prop);
        }
        return byKey;
    }

    public ClusterPropertyList getOverriden(ClusterPropertyList overrides) {
        ClusterPropertyList ret = new ClusterPropertyList();
        Map<String, ClusterProperty> thisByKey = this.getIndexedByKey();
        Map<String, ClusterProperty> overridesByKey = overrides.getIndexedByKey();
        for (ClusterProperty prop : this) {
            if (StringUtils.isBlank((String)prop.key) || prop != thisByKey.get(prop.key)) continue;
            if (!prop.isFinal && overridesByKey.containsKey(prop.key)) {
                ret.add(overridesByKey.get(prop.key));
                continue;
            }
            ret.add(prop);
        }
        for (ClusterProperty prop : overrides) {
            if (StringUtils.isBlank((String)prop.key) || thisByKey.containsKey(prop.key)) continue;
            ret.add(prop);
        }
        return ret;
    }
}

