/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class SchemaValidator {
    public static final int ALLOW_EMPTY_OBJECT_FIELDS = 1;
    public static final int ALLOW_EMPTY_ARRAY_CONTENT = 2;
    public static final int ALLOW_EMPTY_MAP_KEYS = 4;
    public static final int ALLOW_EMPTY_MAP_VALUES = 8;
    public static final int RESTRICT_STRING_MAP_KEYS = 16;
    private final int policy;

    public SchemaValidator() {
        this(0);
    }

    public SchemaValidator(int policy) {
        this.policy = policy;
    }

    public Schema validate(Schema schema) throws SchemaValidationException {
        if (schema == null) {
            throw new SchemaValidationException("The schema is null");
        }
        if (schema.columns == null) {
            throw new SchemaValidationException("The schema's columns list is empty");
        }
        int i = 1;
        for (SchemaColumn sc : schema.columns) {
            if (sc == null) {
                throw new SchemaValidationException("The " + i + "-th column is null in the schema");
            }
            if (StringUtils.isBlank((String)sc.name)) {
                throw new SchemaValidationException("The " + i + "-th column has no name in the schema");
            }
            this.validateCol(sc);
            ++i;
        }
        return schema;
    }

    private void validateCol(SchemaColumn sc) throws SchemaValidationException {
        if (sc == null) {
            throw new SchemaValidationException("Unexpected null type in schema");
        }
        Type type = sc.getType();
        switch (type) {
            case MAP: {
                this.validateMap(sc);
                break;
            }
            case OBJECT: {
                this.validateObject(sc);
                break;
            }
            case ARRAY: {
                this.validateArray(sc);
                break;
            }
        }
    }

    private void validateArray(SchemaColumn sc) throws SchemaValidationException {
        if (sc.arrayContent == null) {
            if ((this.policy & 2) == 0) {
                throw new SchemaValidationException("The 'arrayContent' property cannot be null");
            }
        } else {
            this.validateCol(sc.arrayContent);
        }
    }

    private void validateObject(SchemaColumn sc) throws SchemaValidationException {
        if ((sc.objectFields == null || sc.objectFields.size() == 0) && (this.policy & 1) == 0) {
            throw new SchemaValidationException("The 'objectFields' property must describe at least one field");
        }
        if (sc.objectFields != null) {
            for (SchemaColumn f : sc.objectFields) {
                this.validateCol(f);
            }
        }
    }

    private void validateMap(SchemaColumn sc) throws SchemaValidationException {
        if (sc.mapKeys == null) {
            if ((this.policy & 4) == 0) {
                throw new SchemaValidationException("The 'mapKeys' property must not be null");
            }
        } else {
            if (sc.mapKeys.getType() != Type.STRING && (this.policy & 0x10) != 0) {
                throw new SchemaValidationException("The 'mapKeys' property must not be string");
            }
            this.validateCol(sc.mapKeys);
        }
        if (sc.mapValues == null) {
            if ((this.policy & 8) == 0) {
                throw new SchemaValidationException("The 'mapValues' property must not be null");
            }
        } else {
            this.validateCol(sc.mapValues);
        }
    }

    public static class SchemaValidationException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public SchemaValidationException(String message) {
            super(message);
        }
    }
}

