/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.NodePosition;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Zone
extends TaggableObjectsService.TaggableObject {
    private static final String DEFAULT_ZONE_ID = "default";
    private static final String DEFAULT_ZONE_NAME = "Default";
    private static final String DEFAULT_ZONE_COLOR = "#D1D8DA";
    private static final String DEFAULT_ZONE_PROJECT_KEY = "";
    public static final Zone DEFAULT_ZONE = new Zone("default", "Default", "#D1D8DA", "");
    @JSON.FileTransient
    private String id;
    private String name;
    private String color;
    private Set<SmartObjectRef> items = new HashSet<SmartObjectRef>();
    private Set<SmartObjectRef> shared = new HashSet<SmartObjectRef>();
    @JSON.FileTransient
    private String projectKey;
    private NodePosition position = new NodePosition();

    public Zone(String id, String name, String color, String projectKey, NodePosition position) {
        this(id, name, color, projectKey);
        this.position = position;
    }

    public Zone(String id, String name, String color, String projectKey) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.projectKey = projectKey;
    }

    public Zone() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.FLOW_ZONE;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public boolean isDefaultZone() {
        return Objects.equals(this.name, DEFAULT_ZONE_NAME) && Objects.equals(this.id, DEFAULT_ZONE_ID);
    }

    public Set<SmartObjectRef> getItems() {
        return this.items;
    }

    public void addItem(SmartObjectRef smartObjectRef) {
        this.items.add(smartObjectRef);
    }

    public void removeItem(SmartObjectRef smartObjectRef) {
        this.items.remove(smartObjectRef);
    }

    public Set<SmartObjectRef> getShared() {
        return this.shared;
    }

    public void addZoneShared(SmartObjectRef smartObjectRef) {
        this.shared.add(smartObjectRef);
    }

    public void removeZoneShared(SmartObjectRef smartObjectRef) {
        this.shared.remove(smartObjectRef);
    }

    @Nullable
    public Double getX() {
        return this.position.x;
    }

    @Nullable
    public Double getRightMostX() {
        if (this.position.x == null || this.position.width == null) {
            return null;
        }
        return this.position.x + this.position.width;
    }

    @Nullable
    public Double getY() {
        return this.position.y;
    }

    @Nullable
    public Double getWidth() {
        return this.position.width;
    }

    @Nullable
    public Double getHeight() {
        return this.position.height;
    }

    public boolean hasValidCoordinates() {
        return this.position.x != null && this.position.y != null;
    }

    public boolean hasPosition() {
        return this.position.x != null || this.position.y != null || this.position.height != null || this.position.width != null;
    }

    public boolean dimensionsEquals(double height, double width) {
        double epsilon = 1.0E-6;
        if (this.position.height == null || this.position.width == null) {
            return false;
        }
        return Math.abs(height - this.position.height) < epsilon && Math.abs(width - this.position.width) < epsilon;
    }

    public void clearPosition() {
        this.position = new NodePosition();
    }

    public NodePosition getPosition() {
        return this.position;
    }

    public void setCoordinates(@Nonnull Double x, @Nonnull Double y) {
        this.position.setCoordinates(x, y);
    }

    public void setDimensions(@Nonnull Double height, @Nonnull Double width) {
        this.position.setDimensions(height, width);
    }
}

