/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComputableFromRefService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private ManagedFolderDAO managedFoldersDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;

    public FlowComputable get(String projectKey, String smartName) throws IOException {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartName);
        SavedModel sm = (SavedModel)this.savedModelsDAO.getOrNull(loc);
        if (sm != null) {
            return new FlowSavedModel(sm);
        }
        ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(loc);
        if (mes != null) {
            return new FlowModelEvaluationStore(mes);
        }
        ManagedFolder mf = (ManagedFolder)this.managedFoldersDAO.getOrNull(loc);
        if (mf != null) {
            return new FlowManagedFolder(mf);
        }
        SerializedDataset sds = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc);
        if (sds != null) {
            return new FlowDataset(loc.getFullName());
        }
        StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(loc);
        if (se != null) {
            return new FlowStreamingEndpoint(se);
        }
        RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNull(loc);
        if (rk != null) {
            return new FlowRetrievableKnowledge(rk);
        }
        throw new NotFoundException("Computable not found: " + loc.getFullName());
    }

    public FlowComputable get(TaggableObjectsService.TaggableObjectRef ref) throws IOException {
        AnyLoc loc = ref.getLoc().resolved();
        if (ref.type == ITaggingService.TaggableType.DATASET) {
            this.datasetsDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
            return new FlowDataset(loc.getFullName());
        }
        if (ref.type == ITaggingService.TaggableType.MANAGED_FOLDER) {
            return new FlowManagedFolder((ManagedFolder)this.managedFoldersDAO.getMandatory(loc));
        }
        if (ref.type == ITaggingService.TaggableType.SAVED_MODEL) {
            return new FlowSavedModel((SavedModel)this.savedModelsDAO.getMandatory(loc));
        }
        if (ref.type == ITaggingService.TaggableType.MODEL_EVALUATION_STORE) {
            return new FlowModelEvaluationStore((ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(loc));
        }
        if (ref.type == ITaggingService.TaggableType.STREAMING_ENDPOINT) {
            return new FlowStreamingEndpoint((StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(loc));
        }
        if (ref.type == ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE) {
            return new FlowRetrievableKnowledge((RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(loc));
        }
        throw new IllegalArgumentException("Flow computable type not specified");
    }

    public SerializedDataset getAsDatasetUnsafe(String recipeProjectKey, String smartName) throws IOException {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(recipeProjectKey, smartName);
        return (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getName());
    }

    public SerializedDataset getAsDatasetOrNullUnsafe(String recipeProjectKey, String smartName) throws IOException {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(recipeProjectKey, smartName);
        return (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc.getProjectKey(), loc.getName());
    }

    public boolean existsAsDatasetUnsafe(String recipeProjectKey, String smartName) throws IOException {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(recipeProjectKey, smartName);
        return this.datasetsDAO.exists(loc.getProjectKey(), loc.getName());
    }
}

