/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.grouping;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GroupingRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupingRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private GroupingRecipeService service;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.grouping.status");

    public GroupingRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public GroupingRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), true, authCtx);
    }

    protected void handleNoKey(RecipeStatus.StepStatus stepStatus) {
        stepStatus.withWarning(RecipeCodes.WARN_RECIPE_GROUPING_NO_KEY, "No selected grouping key, aggregations will be computed on the whole dataset.");
    }

    protected void handlePartitionUsedAsGroupKey(RecipeStatus.StepStatus stepStatus, String col) {
        stepStatus.withWarning(RecipeCodes.WARN_RECIPE_GROUPING_PARTITION_USED_AS_KEY, "\"" + col + "\" is a partition column. Be aware that the partitioning mechanism might override the output of this recipe.");
    }

    private GroupingRecipeStatus getEngineIndependentBaseStatus(AuthCtx authCtx, StatusInitializer init) {
        GroupingRecipePayloadParams params;
        GroupingRecipeStatus status = new GroupingRecipeStatus();
        try {
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(this.recipe)));
            params = this.service.loadParams(this.payload, this.recipe, status);
            if (status.isInvalid()) {
                return status;
            }
            assert (params != null);
            status.params = params;
            status.engineParams = params.engineParams;
            init.inputDS = init.activity.getSubgraph().getSingleSourceDataset().getMandatoryUnsafe(this.datasetsDAO);
            init.outputDS = init.activity.getSubgraph().getSingleTargetDataset().getMandatoryUnsafe(this.datasetsDAO);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        status.group = new RecipeStatus.StepStatus();
        if (params.getResolvedGroupingKeys(init.inputDS.getSchema()).isEmpty()) {
            this.handleNoKey(status.group);
        }
        boolean hasAggr = params.globalCount;
        if (params.values != null && !params.values.isEmpty()) {
            HashSet<String> usedNames = new HashSet<String>();
            for (GroupingRecipePayloadParams.GroupingValue val : params.values) {
                if (val.column == null || !val.hasAnyAggr()) continue;
                hasAggr = true;
                usedNames.add(val.column);
            }
            for (int i = 0; i < params.values.size(); ++i) {
                GroupingRecipePayloadParams.GroupingValue val;
                val = params.values.get(i);
                if (val.column != null) continue;
                hasAggr = true;
                if (status.customValues == null) {
                    status.customValues = new RecipeStatus.StepStatus();
                }
                if (StringUtils.isBlank((String)val.customName)) {
                    status.customValues.addMessage(InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_CUSTOM_VALUE, (String)"empty name", (Object[])new Object[0]).withPos(i, 0));
                } else if (usedNames.contains(val.customName)) {
                    status.customValues.addMessage(InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_CUSTOM_VALUE, (String)"duplicate name", (Object[])new Object[0]).withPos(i, 0));
                }
                usedNames.add(val.customName);
            }
            boolean minMaxOnString = false;
            for (GroupingRecipePayloadParams.GroupingValue val : params.values) {
                if (!val.min && !val.max || !StringUtils.isNotBlank((String)val.column) || init.inputDS.getSchema().getColumn(val.column) == null || init.inputDS.getSchema().getColumn(val.column).getType() != Type.STRING) continue;
                minMaxOnString = true;
                break;
            }
            if (minMaxOnString) {
                status.group.withWarning(RecipeCodes.WARN_RECIPE_GROUPING_MIN_MAX, "Min/Max value on 'String' type uses alphabetical order");
            }
        }
        if (!hasAggr && !params.values.isEmpty()) {
            status.group.withWarning(RecipeCodes.WARN_RECIPE_GROUPING_NO_AGGREGATION, "You specified no aggregation.");
        }
        return status;
    }

    public GroupingRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, boolean reportUnknownErrorsToStatus, AuthCtx authCtx) throws IOException, DKUSecurityException {
        GroupingRecipePayloadParams params;
        GroupingRecipeStatus status;
        block14: {
            RecipeEnginesPreferenceConfig repc;
            block13: {
                status = this.getEngineIndependentBaseStatus(authCtx, init);
                if (status.isInvalid()) {
                    return status;
                }
                params = status.params;
                repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, params.enginesPreferences);
                try {
                    this.performBasicStructureChecks(status, authCtx);
                    this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
                    this.performBasicCDEChecks(status, authCtx);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Aggregation in-database, then streaming of aggregates");
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    if (status.isInvalid()) break block13;
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            if (!status.isInvalid()) {
                try {
                    this.makeRecipeSpecificEnginesStatus(authCtx, init, status, params);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Aggregation in-database, then streaming of aggregates");
                    if (status.selectedEngine == null && !status.isInvalid()) {
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No engine selected", new Object[0]);
                        return status;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to init engine: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    return status;
                }
                if (status.getSelectedSQLBasedEngine().queryBased) {
                    try {
                        init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                        boolean h2Mode = status.getSelectedSQLBasedEngine() != null && "DSS".equals(status.getSelectedSQLBasedEngine().type);
                        status.sql = this.service.generateSQLIgnorePartitions(init.dialect, h2Mode, params, init.inputDS, init.outputDS, true);
                        this.checkPartitionKeyUsedAsGrouping(init, status);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to generate SQL", (Throwable)e);
                        init.error = ExceptionUtils.getMessageWithCauses((Throwable)e);
                        if (!reportUnknownErrorsToStatus) break block14;
                        status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to generate SQL: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                }
            }
        }
        if (!status.isInvalid() && params.preFilter != null && params.preFilter.enabled) {
            status.preFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, init.dialect, status.preFilter, false);
        }
        if (!status.isInvalid() && params.computedColumns != null && !params.computedColumns.isEmpty()) {
            status.computedColumns = new RecipeStatus.StepStatus();
            boolean mustLowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, status.getSelectedSQLBasedEngine());
            this.visualRecipesService.checkComputedColumns(params.computedColumns, init.inputDS.getSchema(), status.getSelectedSQLBasedEngine(), init.dialect, mustLowercaseColumns, status.computedColumns);
        }
        if (!status.isInvalid() && params.postFilter != null && params.postFilter.enabled) {
            status.postFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.postFilter, null, init.dialect, status.postFilter, false);
        }
        return status;
    }

    private void checkPartitionKeyUsedAsGrouping(StatusInitializer init, GroupingRecipeStatus status) {
        PartitioningScheme partitionScheme = init.outputDS.getPartitioningSchema();
        if (partitionScheme != null) {
            List partitionKeys = partitionScheme.getDimensionNames();
            for (GroupingRecipePayloadParams.GroupingKey groupKey : status.params.getResolvedGroupingKeys(init.inputDS.getSchema())) {
                if (!partitionKeys.contains(groupKey.column)) continue;
                this.handlePartitionUsedAsGroupKey(status.group, groupKey.column);
            }
        }
    }

    @Override
    public GroupingRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        GroupingRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, true, authCtx);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Try to generate query anyway:");
            }
            status.sql = this.service.generateSQL(init.activity, init.dialect, false, status.params, true);
        }
        return status;
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws IOException, DKUSecurityException {
        boolean lowerCaseColumnsNames;
        GroupingRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, false, authCtx);
            if (status.isInvalid()) {
                this.fixupStatusOutputInvalid(status);
                GroupingRecipeStatus groupingRecipeStatus = status;
                return groupingRecipeStatus;
            }
        }
        GroupingRecipePayloadParams params = status.params;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        Dataset inputDS = init.inputDS;
        SQLDialect dialect = init.dialect;
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(selectedEngine, params);
        }
        String preFilterSQLExpression = null;
        if (dialect != null && params.preFilter != null && (params.preFilter.enabled || params.preFilter.distinct)) {
            status.preFilter = new RecipeStatus.StepStatus();
            boolean translateFully = selectedEngine.queryBased && !selectedEngine.type.equals("DSS");
            preFilterSQLExpression = this.visualRecipesService.checkFilter(params.preFilter, inputDS, dialect, status.preFilter, translateFully);
        }
        try {
            lowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
            status.outputSchemaBeforeOverride = this.service.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute output schema", (Throwable)e);
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute output schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return status;
        }
        String postFilterSQLExpression = null;
        if (dialect != null && status.outputSchemaBeforeOverride != null && params.postFilter != null && (params.postFilter.enabled || params.postFilter.distinct)) {
            status.postFilter = new RecipeStatus.StepStatus();
            boolean translateFully = selectedEngine.queryBased && !selectedEngine.type.equals("DSS");
            postFilterSQLExpression = this.visualRecipesService.checkFilter(params.postFilter, new Dataset().withSchema(status.outputSchemaBeforeOverride), dialect, status.postFilter, translateFully);
        }
        if (status.isInvalid()) {
            this.fixupStatusOutputInvalid(status);
            return status;
        }
        this.checkOutputSchema(status, params, lowerCaseColumnsNames);
        if (this.needToComputeExecutionPlan(selectedEngine, status, request)) {
            boolean executionPlanFailed = false;
            String executionPlanErrMsg = null;
            try {
                status.executionPlan = this.getExecutionPlan(authCtx, inputDS, selectedEngine, status.sql, params.engineParams);
            }
            catch (ExecutionPlanService.HiveTableNotFound e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan, table not found in Hive metastore %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                logger.info((Object)("Query:\n" + status.sql));
                executionPlanFailed = true;
                executionPlanErrMsg = e.getMessage();
                status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute execution plan: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            if (executionPlanFailed) {
                try {
                    this.investigateExecutionPlanFailure(status, init, executionPlanErrMsg, authCtx, preFilterSQLExpression, postFilterSQLExpression);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to determe error cause", (Throwable)e);
                }
            }
        }
        if (init.error != null && !status.isInvalid()) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Unknown error: %s", new Object[]{init.error});
        }
        this.fixupStatusOutputInvalid(status);
        return status;
    }

    private void fixupStatusOutputInvalid(VisualSQLRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    private void makeRecipeSpecificEnginesStatus(AuthCtx authCtx, StatusInitializer init, GroupingRecipeStatus status, GroupingRecipePayloadParams params) throws Exception {
        logger.infoV("Computing engine status for grouping recipe", new Object[0]);
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            if (!engine.isSelectable) continue;
            if (engine.type.equals("DSS") && this.dssEngineNeedsH2(params)) {
                VisualSQLRecipesBaseService.h2ModeOn(engine, false, null, null);
            }
            if (!engine.canDistinctSelect) {
                if (params.preFilter != null && params.preFilter.distinct) {
                    RecipeEngineStatus.setErrorStatus("Cannot use DISTINCT in pre-filter", engine);
                    continue;
                }
                if (params.postFilter != null && params.postFilter.distinct) {
                    RecipeEngineStatus.setErrorStatus("Cannot use DISTINCT in post-filter", engine);
                    continue;
                }
            }
            if (engine.queryBased) {
                try {
                    SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                    boolean h2Mode = engine != null && "DSS".equals(engine.type);
                    this.service.generateSQLIgnorePartitions(dialect, h2Mode, status.params, init.inputDS, init.outputDS, false);
                }
                catch (Exception e) {
                    if (engine.type.equals("DSS")) {
                        RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    }
                    RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                }
            }
            if (!engine.type.equals("DSS")) continue;
            for (GroupingRecipePayloadParams.GroupingValue gv : params.values) {
                if (!gv.median) continue;
                RecipeEngineStatus.setErrorStatus("Median is not supported by DSS engine", engine);
            }
        }
    }

    private boolean dssEngineNeedsH2(GroupingRecipePayloadParams params) {
        for (GroupingRecipePayloadParams.GroupingValue val : params.values) {
            if (val.column != null) continue;
            return true;
        }
        if (params.preFilter != null && (params.preFilter.distinct || params.preFilter.getExpressionLanguage() == FilterDesc.ExpressionLanguage.SQL)) {
            return true;
        }
        if (params.postFilter != null && (params.postFilter.distinct || params.postFilter.getExpressionLanguage() == FilterDesc.ExpressionLanguage.SQL)) {
            return true;
        }
        if (params.computedColumns != null) {
            for (ComputedColumn computedColumn : params.computedColumns) {
                if (computedColumn.mode != ComputedColumn.Mode.SQL) continue;
                return true;
            }
        }
        return false;
    }

    private void checkOutputSchema(GroupingRecipeStatus status, GroupingRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        try {
            if (status.outputSchemaBeforeOverride != null) {
                status.outputSchema = new Schema(status.outputSchemaBeforeOverride);
                if (params.outputColumnNameOverrides != null) {
                    HashSet<String> usedNames = new HashSet<String>();
                    for (SchemaColumn sc : status.outputSchema.columns) {
                        String colName = sc.getName();
                        String overrideName = params.outputColumnNameOverrides.get(sc.getName());
                        if (StringUtils.isNotBlank((String)overrideName)) {
                            colName = overrideName;
                            if (lowerCaseColumnsNames) {
                                overrideName = overrideName.toLowerCase();
                            }
                            sc.setName(overrideName);
                        }
                        if (StringUtils.isNotBlank((String)(colName = colName.toLowerCase())) && usedNames.contains(colName)) {
                            status.output.withFatalV(RecipeCodes.ERR_RECIPE_GROUPING_DUPLICATE_OUTPUT, "Duplicate name: '" + colName + "'", new Object[0]);
                        }
                        usedNames.add(colName);
                    }
                }
                if (status.outputSchema.columns.size() == 0) {
                    status.output.withFatalV(RecipeCodes.ERR_RECIPE_EMPTY_OUTPUT_SCHEMA, "Empty output schema", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            status.output.withFatalV(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Error computing schema: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
    }

    private void investigateExecutionPlanFailure(GroupingRecipeStatus status, StatusInitializer init, String executionPlanErrMsg, AuthCtx authCtx, String preFilterSQLExpression, String postFilterSQLExpression) throws Exception {
        String sql;
        Schema inputSchema;
        if (status.getSelectedSQLBasedEngine().type.equals("HIVE")) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, executionPlanErrMsg);
            return;
        }
        boolean errorOriginFound = false;
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        boolean isH2Mode = VisualSQLRecipesBaseService.SQLBasedEngineStatus.isH2Mode(status.getSelectedSQLBasedEngine());
        SQLUtils.SQLTable table = isH2Mode ? new SQLUtils.SQLTable(null, null, init.inputDS.getFullName(), false) : DatasetUtils.getResolvedTableWithSparkSQLFallback(init.inputDS, init.dialect, status.params.engineParams);
        List<GroupingRecipePayloadParams.GroupingKey> resolvedGroupingKeys = status.params.getResolvedGroupingKeys(init.inputDS.getSchema());
        if (!resolvedGroupingKeys.isEmpty()) {
            for (int k = 0; k < resolvedGroupingKeys.size(); ++k) {
                GroupingRecipePayloadParams.GroupingKey key = resolvedGroupingKeys.get(k);
                if (key.column != null) continue;
                status.group.addMessage(InfoMessage.fatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_KEY, (String)"Grouping key without column", (Object[])new Object[0]).withPos(k, 0));
            }
        }
        if (status.params.values != null && !status.params.values.isEmpty() && (inputSchema = init.inputDS.getSchema()) != null && !inputSchema.columns.isEmpty()) {
            String firstColumn = ((SchemaColumn)inputSchema.columns.get(0)).getName();
            for (int i = 0; i < status.params.values.size(); ++i) {
                GroupingRecipePayloadParams.GroupingValue value = status.params.values.get(i);
                if (value.column != null) continue;
                if (StringUtils.isBlank((String)value.customName)) {
                    status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_CUSTOM_VALUE, (String)"Empty name").withPos(i, 0));
                    continue;
                }
                if (StringUtils.isBlank((String)value.customExpr)) {
                    status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_CUSTOM_VALUE, (String)"Empty expression").withPos(i, 0));
                    continue;
                }
                String sql2 = null;
                try {
                    SelectQueryBuilder qb = new SelectQueryBuilder();
                    qb.select(ef.expr(value.customExpr));
                    qb.from(table, null);
                    qb.group(ef.col(firstColumn));
                    sql2 = qb.toSQL(init.dialect);
                    logger.info((Object)("Check custom aggregation " + value.customName));
                    logger.info((Object)sql2);
                    this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql2, status.params.engineParams);
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)"grouping value test failed:");
                    logger.info(sql2);
                    status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_CUSTOM_VALUE, (String)this.formatDatabaseErrorMsg(e.getMessage(), init.dialect)).withPos(i, 0));
                    errorOriginFound = true;
                }
            }
        }
        if (preFilterSQLExpression != null) {
            SelectQueryBuilder qb = new SelectQueryBuilder();
            qb.from(table, null);
            qb.where(ef.expr(preFilterSQLExpression));
            sql = qb.toSQL(init.dialect);
            try {
                this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql, status.params.engineParams);
            }
            catch (Exception e) {
                logger.error((Object)"Prefilter execution failed:", (Throwable)e);
                logger.error((Object)sql);
                status.preFilter.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_FILTER, (String)this.formatDatabaseErrorMsg(e.getMessage(), init.dialect)).withPos(1, 0));
                errorOriginFound = true;
            }
        }
        if (postFilterSQLExpression != null) {
            try {
                GroupingRecipePayloadParams params2 = (GroupingRecipePayloadParams)JSON.deepCopy((Object)status.params);
                params2.postFilter = null;
                sql = this.service.generateSQLIgnorePartitions(init.dialect, isH2Mode, params2, init.inputDS, init.outputDS, false);
                this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql, status.params.engineParams);
                status.postFilter.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_GROUPING_INVALID_FILTER, (String)this.formatDatabaseErrorMsg(executionPlanErrMsg, init.dialect)).withPos(1, 0));
                errorOriginFound = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!errorOriginFound) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
        }
    }

    public static class StatusInitializer {
        public Dataset inputDS;
        public Dataset outputDS;
        public SQLDialect dialect;
        public JobActivity activity;
        public String error;
    }

    public static class GroupingRecipeStatus
    extends VisualSQLRecipeStatus {
        public RecipeStatus.StepStatus preFilter;
        public RecipeStatus.StepStatus computedColumns;
        public RecipeStatus.StepStatus group;
        RecipeStatus.StepStatus customValues;
        public RecipeStatus.StepStatus postFilter;
        GroupingRecipePayloadParams params;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            if (this.preFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.preFilter);
            }
            if (this.computedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.computedColumns);
            }
            if (this.group != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.group);
            }
            if (this.customValues != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.customValues);
            }
            if (this.postFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.postFilter);
            }
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }
}

