/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.h2;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.h2.ColumnAdderFilteringProcessorOutput;
import com.dataiku.dip.dataflow.exec.h2.DatasetToH2ConnectionLoader;
import com.dataiku.dip.dataflow.exec.h2.H2DB;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.processors.transform.StringTransformation;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;

public class DatasetToH2Loader
extends DatasetToH2ConnectionLoader {
    public H2DB h2db;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.h2loader");

    public DatasetToH2Loader(AuthCtx authCtx, WarningsContext warningsContext, String projectKey, H2DB h2db) throws Exception {
        super(authCtx, warningsContext, projectKey, h2db.getAdminConn(), (H2SQLDialect)h2db.getConnData().getDialect(), h2db.folder);
        this.h2db = h2db;
    }

    public void load(Dataset dataset, StreamableDatasetSelection selection, String targetTable, List<String> requiredColumnNames, List<JoinRecipeHelper.SimpleVirtualColumn> virtualColumns) throws Exception {
        VirtualColumnsAdder columnsAdder = null;
        if (virtualColumns != null && !virtualColumns.isEmpty()) {
            columnsAdder = new VirtualColumnsAdder(virtualColumns);
        }
        Dataset h2Dataset = super.loadInDB(dataset, selection, targetTable, requiredColumnNames, columnsAdder, new AutoDelete(this.h2db.tableFile(targetTable)), false);
        this.h2db.addDataset(h2Dataset);
    }

    public H2DB createTestTable(Dataset dataset) throws SQLException {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        String tableName = dataset.getFullName();
        for (SchemaColumn col : dataset.getSchema().columns) {
            try {
                this.dialect.getSQLType(col, dataset);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (!first) {
                sb.append(',');
            }
            sb.append(this.dialect.quoteIdentifier(col.getName()));
            sb.append(' ');
            sb.append(this.dialect.getSQLType(col, dataset));
            first = false;
        }
        String columnListExpr = sb.toString();
        String sql = this.dialect.createTemporaryTable(new SQLUtils.SQLTable(tableName), columnListExpr);
        try (Statement stmt = this.h2db.getConn().createStatement();){
            logger.info((Object)"Creating empty H2 table. Statement:");
            logger.info((Object)sql);
            stmt.execute(sql);
        }
        return this.h2db;
    }

    @Override
    public void close() throws Exception {
        this.h2db.close();
    }

    private static class VirtualColumnsAdder
    extends ColumnAdderFilteringProcessorOutput {
        List<Column> inputColumns = Lists.newArrayList();
        List<Column> outputColumns = Lists.newArrayList();
        List<StringTransformation> transformations = Lists.newArrayList();
        private final List<SchemaColumn> addedColumns;
        final List<JoinRecipeHelper.SimpleVirtualColumn> virtualColumns;

        public VirtualColumnsAdder(List<JoinRecipeHelper.SimpleVirtualColumn> virtualColumnDefinitions) {
            assert (virtualColumnDefinitions != null);
            this.virtualColumns = virtualColumnDefinitions;
            this.addedColumns = this.virtualColumns.stream().map(vc -> new SchemaColumn(vc.virtualColumnName, Type.STRING)).collect(Collectors.toList());
        }

        public void emitRow(Row row) throws Exception {
            for (int i = 0; i < this.inputColumns.size(); ++i) {
                Column oc = this.outputColumns.get(i);
                Column ic = this.inputColumns.get(i);
                if (row.empty(ic)) {
                    row.delete(oc);
                    continue;
                }
                row.put(oc, this.transformations.get(i).transform(row.get(ic), null));
            }
            this.downstream.emitRow(row);
        }

        @Override
        public List<SchemaColumn> addedColumns() {
            return this.addedColumns;
        }

        @Override
        public void withColumnFactory(ColumnFactory cf) {
            for (JoinRecipeHelper.SimpleVirtualColumn def : this.virtualColumns) {
                this.inputColumns.add(cf.column(def.inputColumnName));
                this.outputColumns.add(cf.column(def.virtualColumnName));
                this.transformations.add(def.transformation);
            }
        }
    }
}

